<?php

$categories = [
  'ani' => 'Animals & Nature',
  'art' => 'Art & Culture',
  'car' => 'Cars & Bikes',
  'cor' => 'Corporations & Organizations',
  'des' => 'Design & Photography',
  'edu' => 'Education & Science',
  'ent' => 'Entertainment',
  'fas' => 'Fashion',
  'fin' => 'Finance',
  'foo' => 'Food & Restaurants',
  'hea' => 'Health & Beauty',
  'hou' => 'Housing & Architecture',
  'mag' => 'Magazines & Writing',
  'occ' => 'Occasions & Gifts',
  'oth' => 'Others',
  'peo' => 'People and services',
  'pro' => 'Product & Production',
  'spo' => 'Sports & Travel',
  'tec' => 'Technology & Computing ',
];

$layouts = [
  'one'	=> 'One Page',
  'por'	=> 'Portfolio',
  'box'	=> 'Boxed',
  'blo'	=> 'Blog',
  'dar'	=> 'Dark',
  'lig'	=> 'Light',
  'mob'	=> 'Mobile First',
  'sho'	=> 'WooCommerce',
  'ele'	=> 'Elementor',
];

$plugins = [
  'cf7'	=> [
    'name' => 'Contact Form 7',
    'slug' => 'contact-form-7',
    'desc' => 'Just another contact form plugin. Simple but flexible.',
    'action' => false, // 'install', 'activate', 'update'
  ],
  'ele'	=> [
    'name' => 'Elementor',
    'slug' => 'elementor',
    'desc' => 'The Elementor Website Builder: drag and drop page buildern, responsive editing, and more.',
    'dark' => true,
    'action' => false,
  ],
  'rev'	=> [
    'name' => 'Revolution Slider',
    'slug' => 'revslider',
    'desc' => 'Slider Revolution - More than just a WordPress Slider.',
    'action' => false,
  ],
  'woo'	=> [
    'name' => 'WooCommerce',
    'slug'	=> 'woocommerce',
    'desc' => 'An eCommerce toolkit that helps you sell anything. Beautifully.',
    'dark' => true,
    'action' => false,
  ],
];

$tresaurus = [
	'3d' => 'design render graphic',
	'3dprint' => 'filament abs production manufacture design',
	'accountant' => 'auditor bookkeeper',
	'active' => 'beauty health diet',
	'actor' => 'movie video cv actress',
	'adagency' => 'advertisement design',
	'adventure' => 'travel journey sightseeing touring tourists',
	'aeroclub' => 'flight plane parachuting airport fly',
	'agency' => 'interactive business digital portfolio design',
	'agro' => 'farmer supplier food cultivation animals',
	'ai' => 'artificial intelligence science knowledge neural network machine learning',
	'airport' => 'plane fly travel aeroclub flight parachuting',
	'animals' => 'pets cats dogs',
	'animalshelter' => 'pets cats dogs volunteering',
	'app' => 'application software',
	'aquapark' => 'swimming water relax',
	'architect' => 'creator builder constructor building',
	'aromatherapy' => 'relax pleasure mentalhealth',
	'art' => 'artist painting design',
	'artist' => 'painting sketching design',
	'asg' => 'shooting firing weapon game gun paintball',
	'assistance' => 'road car help sos emergency vehicles',
	'astrology' => 'horoscope astrometry ',
	'babyshop' => 'store fashion clothes linen kids children',
	'baker' => 'food bread cake',
	'band' => 'music artist concert',
	'bar' => 'pub restaurant food drink alcohol drink liquor spirits',
	'barber' => 'haircut hairdresser hairstylist',
	'barman' => 'alcohol drink liquor spirits',
	'beauty' => 'health',
	'biker' => 'sport relax recreation health',
	'bikerental' => 'biker sport',
	'billiard' => 'relax sport club ball',
	'biolab' => 'laboratory biology science',
	'birthday' => 'party celebrate',
	'bistro' => 'food drink meal party',
	'blogger' => 'journalist articles stories press internet',
	'book' => 'author autor writer novel',
	'boutique' => 'fashion clothes style',
	'boxing' => 'pugilism combar sport fight',
	'buddy' => 'buddypress community',
	'builder' => 'construction building skyscraper developer architecture',
	'burger' => 'meal snack fast food hotdog',
	'business' => 'corporation organization work employment job',
	'bw' => 'black and white design',
	'cafe' => 'relax drink meeting food cakes coffee',
	'cakes' => 'candy bakery',
	'callcenter' => 'sale calling phone helpline support',
	'car' => 'automobile vehicles manufacturer',
	'carparts' => 'vehicle workshop shop store',
	'carpenter' => 'furniture design artist wood home craft',
	'carrental' => 'car transport vehicle',
	'carver' => 'sculptor wood design',
	'carwash' => 'automobile clean services vehicles',
	'casino' => 'game gambling money hazard',
	'catering' => 'food drink ceremony organize party',
	'charity' => 'volunteering help poor',
	'church' => 'religion cult prayer rithual theology',
	'cityhall' => 'town hall municipal government ',
	'cleaner' => 'cleaning services housekeeping',
	'clinic' => 'medic doctor health',
	'clothing' => 'clothes store shop fashion',
	'clothingstore' => 'store fashion clothes',
	'club' => 'party drink dance music concert',
	'coach' => 'bus travel trip journey tour drive',
	'coaching' => 'educator instructor lecturer mentor coach governor guardian guide preceptor prof private teacher ',
	'code' => 'programmer computer webdesign www php js',
	'coffee' => 'cafe drink restaurant food',
	'company' => 'business brand',
	'computershop' => 'laptop notebook internet',
	'congress' => 'politician politics',
	'constructor' => 'construction building skyscraper developer architecture',
	'consultant' => 'advisor expert specialist master mentor',
	'copywriter' => 'stories books text',
	'corporation' => 'business company enterprise',
	'cosmetics' => 'beauty makeup',
	'cottage' => 'house dwelling village country',
	'county' => 'travel journey sightseeing touring tourists',
	'course' => 'training education',
	'couturier' => 'fashion designer manufacture clothes',
	'coworking' => 'space business job work meeting place',
	'craftbeer' => 'alcohol drink liquor spirits manufacture',
	'creative' => 'product agency advertisement portfolio',
	'cryptocurrency' => 'finance bitcoin cash money investment banking',
	'cv' => 'work job experience',
	'danceschool' => 'lessons course training samba tango hiphop academy education',
	'data' => 'science machine learning artificial intelligence',
	'decor' => 'house furniture design decoration',
	'denim' => 'jeans shop store fashion',
	'dentist' => 'health medic doctor',
	'design' => 'interior home artist furniture painting graphic illustrations',
	'detailing' => 'cars automobile clean services vehicles',
	'developer' => 'constructor builder apartment building house home',
	'diet' => 'health ecofood',
	'dietitian' => 'health food lifestyle',
	'dietshop' => 'ecology vegetables fruits food health',
	'digital' => 'agency portfolio',
	'disco' => 'party dance music',
	'dj' => 'disco club music play dance',
  'doctor' => 'health medic',
	'drawing' => 'artist painting illustrator',
	'driving' => 'school learn training car wehicles',
	'drone' => 'unmanned aerial vehicle fly film',
	'ebook' => 'reading landingpage',
	'eco' => 'nature health environment',
	'ecobeef' => 'ecology meat food',
	'ecofood' => 'ecology vegetables fruits',
	'elearning' => 'school course lesson teacher',
	'electric' => 'electrician electricity power',
	'electronics' => 'rtv repair renovation electric devices',
	'employment' => 'business job agency work',
	'energy' => 'ecology power electicity',
	'erp' => 'enterprise resource planning management business',
	'estate' => 'realtor home house property removal',
	'event' => 'meeting party concert',
	'exposure' => 'photography model artist',
	'extreme' => 'sport adventure adrenaline',
	'factory' => 'producer manufacturer',
	'fantasy' => 'book movie gaming board game',
	'fareast' => 'asia china travel journey',
	'farm' => 'farmer supplier food cultivation animals',
	'farmer' => 'supplier food cultivation animals',
	'fashion' => 'clothes beauty makeup cosmetics',
	'festival' => 'event concert performance',
	'finance' => 'investment money',
	'firebrigade' => 'fire department',
	'fireplace' => 'wood fuel chimney furnace stove',
	'firm' => 'company business organization',
	'fisher' => 'fisherman',
	'fit' => 'health body ecofood',
	'fitness' => 'sport health training shape',
	'fix' => 'repair service house help',
	'flower' => 'nature environment',
	'foodtruck' => 'meal snack burger fast food hotdog',
	'football' => 'soccer game club team sport',
	'franchise' => 'greengrocery supermarket delicatessen store ',
	'freelancer' => 'designer cv portfolio',
	'funeralhome' => 'death ceremony',
	'funfair' => 'joy rollercoaster merry-go-round relax',
	'furniture' => 'design carpenter handyman house',
	'game' => 'play relax entertainment computer console',
	'garden' => 'gerdener grass nature architect house',
	'glasses' => 'fashion manufacturer sunglasses',
	'golf' => 'sport club course',
	'goodfood' => 'ecofood health diet cooking',
	'grocery' => 'greengrocery supermarket delicatessen store ',
	'gsmservice' => 'mobile smartphone tablet repair',
	'guesthouse' => 'journey hotel booking airbnb',
	'gunrange' => 'shooting firing weapon training',
	'gym' => 'fitness training health bodybuilding muscles',
	'hairdresser' => 'haircut barber hairstylist',
	'halloween' => 'trick or treat traditional custom',
	'handmade' => 'fashion clothes manufacturer',
	'handyman' => 'wood design furniture house',
	'healthy' => 'doctor medicine clinic',
	'hemp' => 'cbd marijuana canabis drug',
	'herbal' => 'natural tea brew drink',
	'hifi' => 'music audio stereo',
	'hiphop' => 'danceschool music beat',
	'history' => 'press articles stories',
	'holding' => 'company business brand',
	'home' => 'interior design furniture house',
	'honey' => 'sweet food bees sugar',
	'horse' => 'riding school animals',
	'hosting' => 'server internet www http administrator vpn',
	'hotel' => 'motel hostel resort restaurant airbnb booking spa',
	'hr' => 'human resources workforce organization business employment job',
	'icecream' => 'sugar milk snack food',
	'industry' => 'manufacture production',
	'insurance' => 'protect travel safe help sos',
	'interactive' => 'business agency',
	'interior' => 'home design',
	'internet' => 'network connection communication www http wifi',
	'investment' => 'money banking finance cryptocurrency stocks bitcoin',
	'it' => 'business programmer computer webdesign www php js',
	'itservice' => 'repair computer technology',
	'jet' => 'airport plane travel',
	'jeweler' => 'diamonds gold silver fashion',
	'journalist' => 'press articles stories',
	'journey' => 'travel journey sightseeing touring tourists',
	'karting' => 'motorsport driver car competition race rally',
	'kebab' => 'meal snack burger fast food hotdog',
	'kids' => 'children learn play school course',
	'kindergarten' => 'children kids play school learning',
	'kravmaga' => 'sport fight training',
	'lab' => 'science biology',
	'landing' => 'landingpage product',
	'language' => 'school course lesson teacher',
	'launch' => 'under construction',
	'lawyer' => 'advocate counselor defender procurator',
	'leasing' => 'finance money loan',
	'library' => 'books culture knowledge',
	'lifestyle' => 'journey travel biography people',
	'loans' => 'money finance banking',
	'logistics' => 'transport company truck delivery package',
	'lottie' => 'animation animate design',
	'makeup' => 'beauty cosmetics',
	'mall' => 'supermarket store shopping commerce',
	'manicure' => 'nails cosmetic beauty',
	'marathon' => 'endurance running long distance foot race',
	'marina' => 'boat rent swimming boatyard harbor',
	'marketing' => 'product landing page',
	'massage' => 'relax body health pleasure',
	'meat' => 'ecofood beef manufacture',
	'mechanic' => 'car vehicle repair workshop',
	'media' => 'advertisement design',
	'medic' => 'medicine clinic doctor health',
	'medicalshop' => 'pharmacy pharmaceutical store',
	'meeting' => 'webinar conference symposium',
	'minimal' => 'design photography simple',
	'mining' => 'manufacture production coal stone',
	'mockup' => 'portfolio design illustration image',
	'model' => 'fashion beauty photography',
	'moto' => 'motorcycle motorbike',
	'mountainguide' => 'leads travelers tourists person pilot touring sightseeing',
	'movie' => 'film landing page trailer video',
	'moving' => 'transport',
	'museum' => 'art culture scalpture painting',
	'music' => 'entertainment song album artist',
	'musician' => 'guitar song artist',
	'navigation' => 'tracking monitoring gps',
	'ngo' => 'nongovernmental organization nonprofit humanitarianism',
	'notebook' => 'computer technology macbook apple',
	'nursinghome' => 'care protection help old grandma grandfather grandmother grandparents',
	'oculist' => 'medic doctor glasses eyes',
	'onepage' => 'landingpage',
	'optics' => 'medic doctor sunglasses eyes oculist',
	'organic' => 'ecology vegetables fruits food',
	'paintball' => 'shooting firing weapon game gun',
	'painter' => 'artist painting',
	'parallax' => 'landingpage product',
	'party' => 'dance music new year club disco',
	'pay' => 'contactless payment money smartphone nfc',
	'perfume' => 'cosmetics scent beauty',
	'personaltrainer' => 'advisor expert specialist master sport training health',
	'pestcontrol' => 'food cultivation',
	'pet' => 'companion animal dog cat',
	'pets' => 'animals dogs cats',
	'pharmacy' => 'medical shop drugs health',
	'philharmonic' => 'music artist performance concert',
	'photo' => 'photographer studio art images camera',
	'photography' => 'photographer studio art images camera',
	'pizza' => 'meal fast food restaurant italy',
	'play' => 'contest lottery landing page',
	'plumber' => 'water plumbing services',
	'pole' => 'danceschool music beat training sport',
	'politics' => 'elections political party',
	'polyglot' => 'linguist wordsmith multilingual person language',
	'portfolio' => 'mockup portfolio design illustration image cv',
	'pr' => 'public relations agency',
	'press' => 'journalist articles stories',
	'print' => 'printing house advertisement business card',
	'product' => 'produce manufacture landingpage',
	'productions' => 'studio film video advertisement',
	'profile' => 'cv portfolio',
	'psychologist' => 'clinician doctor psychoanalyst psychotherapist shrink',
	'rallydriver' => 'race car motorist vehicles',
	'recipes' => 'cooking food',
	'records' => 'music song studio artist',
	'renovate' => 'repair house home remodeling property',
	'repair' => 'service home',
	'resort' => 'hotel travel journey rest',
	'restaurant' => 'food drink ceremony organize party menu cook',
	'resume' => 'designer cv portfolio',
	'retouch' => 'photography retouch',
	'robotics' => 'science manufacture production factory',
	'safari' => 'wildlife animals travel journey africa',
	'salmon' => 'ecofood fresh fish meat',
	'school' => 'course lesson teacher students children kids classroom',
	'science' => 'laboratory biology',
	'sciencecentre' => 'museum education lessons',
	'scooterrental' => 'transport motorbike',
	'seajourney' => 'adventure trip boat water sailing yacht',
	'security' => 'protection cctv safeguard',
	'seo' => 'search engine optimization website traffic',
	'service' => 'repair electronic devices',
	'shoes' => 'fashion clothes style shop store',
	'shop' => 'store mall fashion clothes',
	'shopassistant' => 'google advertisement ecommerce seo audit',
	'showcase' => 'photography design mockup',
	'simple' => 'simple minimalism',
	'sitter' => 'kindergarten nanny kids children',
	'sketch' => 'painting artist design',
	'ski' => 'skiers skis snowboarders winter',
	'smart' => 'application landing page',
	'smarthome' => 'house technology automation remote control',
	'snapshot' => 'landscape photography nature wildlife',
	'snowpark' => 'terrain skiers skis snowboarders winter',
	'software' => 'application landing page',
	'spa' => 'relax health beauty',
	'space' => 'science universe exploration',
	'sport' => 'training football soccer',
	'sportsclub' => 'health fitness training tennis squash court pool',
	'sportsman' => 'fitness running training',
	'steak' => 'meal burger food restaurant',
	'stone' => 'manufacture production granite marble mining',
	'store' => 'shop fashion clothes',
	'story' => 'books articles writer',
	'stylist' => 'fashion clothes style',
	'supplier' => 'provider transport',
	'surfing' => 'sport water summer sea wind',
	'surveyor' => 'inspector surveyor supervisor superintendent examiner warden',
	'sushi' => 'meal snack food restaurant fish rice',
	'swimmingpool' => 'lessons course training',
	'tailor' => 'fashion clothes style',
	'tattoo' => 'artist beauty',
	'taxi' => 'transport cab driver car uber',
	'tea' => 'natural tea brew drink herbs',
	'technics' => 'electronics technology manufacturer',
	'theater' => 'culture actor actress performance art',
	'thriller' => 'movie film landing page trailer video',
	'tiles' => 'ceramic tilework home house decoration',
	'tire' => 'car vehicle repair workshop service assistance sos',
	'tourist' => 'travel journey sightseeing touring tourists explore',
	'toy' => 'kids children play',
	'training' => 'lessons course training education',
	'transfer' => 'taxi uber travel cab driver',
	'translator' => 'languages books',
	'transport' => 'car vehicles logistics truck supply',
	'travel' => 'travel journey sightseeing touring tourists explore',
	'tuning' => 'cars automobile services vehicles power',
	'tutor' => 'educator instructor lecturer mentor coach governor guardian guide preceptor prof private teacher ',
	'typo' => 'typography fonts',
	'underwater' => 'oceanarium sea fishes wildlife',
	'universe' => 'space exploration science',
	'university' => 'school course lesson teacher students',
	'upholsterer' => 'furniture design artist',
	'vegetables' => 'ecofood',
	'vet' => 'pets animals dogs cats health medic',
	'video' => 'cameraman movie',
	'vision' => 'eye doctor oculist glasses medic',
	'voyager' => 'travel journey sightseeing touring tourists explore',
	'vpn' => 'internet security web www browser',
	'wallet' => 'payment finance money',
	'wanderer' => 'travel journey sightseeing touring tourists',
	'watch' => 'iwatch landingpage',
	'watchmaker' => 'producer manufacturer',
	'webdesign' => 'developer webpage www agency',
	'webdeveloper' => 'webdesign websites applications www',
	'webinar' => 'conferencing collaborative services online meeting',
	'webmaster' => 'webdeveloper webdesign websites applications www',
	'wedding' => 'marriage bride groom husband wife matrimony ceremony',
	'weddingband' => 'marriage bride groom husband wife matrimony ceremony song music',
	'weddingdresses' => 'marriage bride groom husband wife matrimony ceremony',
	'weddingphotos' => 'marriage bride groom husband wife matrimony ceremony photography',
	'weddingplanner' => 'marriage bride groom husband wife matrimony ceremony organize',
	'weddingservices' => 'marriage bride groom husband wife matrimony ceremony planner organize',
	'weddingvideos' => 'marriage bride groom husband wife matrimony ceremony cameraman',
	'whiskey' => 'alcohol drink liquor spirits',
	'wildlife' => 'nature animals',
	'wine' => 'alcohol drink liquor spirits grapes',
	'winter' => 'skiers skis snowboarders snowmobile',
	'writer' => 'books literature',
	'xmas' => 'christmas winter holiday tree santa',
	'yacht' => 'boat water sailing sea',
	'yoga' => 'fitness training mental health',
	'zoo' => 'animals wildlife',
];

/*
// default pages
$defaults = [
	'page_on_front' => 'Home',
	'page_for_posts' => 'Blog',
	'woocommerce_shop_page_id' => 'Shop',
	'woocommerce_cart_page_id' => 'Cart',
	'woocommerce_checkout_page_id' => 'Checkout',
	'woocommerce_myaccount_page_id' => 'My account',
	'woocommerce_terms_page_id' => 'Privacy Policy',
];
*/

$demos = [

  // default

	'theme' => [
		'name' => 'Default',
		'url' => 'https://themes.muffingroup.com/betheme/',
		'layouts' => ['blo','por'],
		'categories' => ['oth'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['theme.zip','betheme-blog.zip','betheme-portfolio.zip'],
	],
	'bethemestore' => [
		'name' => 'Default Store',
		'url' => 'https://themes.muffingroup.com/betheme-store/',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['des','cor','tec','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'revslider' => ['bethemestore.zip','bethemestore-content.zip'],
		'wrapper' => '1280',
	],
  'bethemestore2' => array(
    'name' => 'Default Store 2',
    'url' => 'https://themes.muffingroup.com/betheme-store/',
    'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['des','cor','tec','pro'],
    'plugins' => [ 'cf7', 'rev', 'woo', 'ele' ],
    'wrapper' => '1240',
    'new' => true,
  ),

  // pre-built


  'clothingstore2' => [
		'name' => 'Clothing Store 2',
		'layouts' => [ 'blo', 'sho', 'lig', 'ele', 'mfn' ],
		'categories' => [ 'fas', 'occ', 'mag', 'pro' ],
		'plugins' => [ 'cf7', 'rev', 'woo', 'ele' ],
		'wrapper' => '1170',
    'pages' => [
      'page_for_posts' => 'Discover the world of our brand',
    ],
	],
  'doctor' => array(
		'name' => 'Doctor',
    'layouts' => [ 'lig', 'ele', 'mfn' ],
		'categories' => [ 'hea', 'peo' ],
		'plugins' => [ 'cf7', 'ele' ],
		'wrapper' => '1330',
	),
  'business6' => array(
		'name' => 'Business 6',
    'layouts' => [ 'blo', 'ele', 'mfn' ],
		'categories' => [ 'cor', 'hou' ],
		'plugins' => [ 'cf7', 'rev', 'ele' ],
		'wrapper' => '1220',
	),
  'biker4' => array(
		'name' => 'Biker 4',
    'layouts' => [ 'sho', 'ele', 'mfn' ],
		'categories' => [ 'car', 'peo', 'spo', 'pro' ],
		'plugins' => [ 'cf7', 'rev', 'woo', 'ele' ],
		'wrapper' => '1280',
		'pages' => [
			'woocommerce_shop_page_id' => 'Bicycles',
		],
	),
	'vr' => array(
		'name' => 'VR',
    'layouts' => [ 'one', 'ele', 'mfn' ],
		'categories' => [ 'tec', 'ent', 'pro' ],
		'plugins' => [ 'cf7', 'rev', 'ele' ],
		'wrapper' => '1270',
	),
	'furniturestore' => array(
		'name' => 'Furniture Store',
    'layouts' => [ 'sho', 'lig', 'ele', 'mfn' ],
		'categories' => [ 'cor', 'hou' ],
		'plugins' => [ 'cf7', 'rev', 'woo', 'ele' ],
		'wrapper' => '1280',
	),
	'marketing2' => array(
		'name' => 'Marketing 2',
    'layouts' => [ 'sho', 'lig', 'ele', 'mfn' ],
		'categories' => [ 'des', 'edu', 'peo' ],
		'plugins' => [ 'cf7', 'rev', 'woo', 'ele' ],
		'wrapper' => '1270',
		'pages' => [
			'woocommerce_shop_page_id' => 'Packages',
		],
	),
	'carwash3' => array(
		'name' => 'Car Wash 3',
    'layouts' => [ 'ele', 'mfn' ],
		'categories' => [ 'car', 'peo' ],
		'plugins' => [ 'cf7', 'rev', 'ele' ],
		'wrapper' => '1260',
	),
	'renovate5' => array(
		'name' => 'Renovate 5',
    'layouts' => [ 'lig', 'ele', 'mfn' ],
		'categories' => [ 'peo', 'hou' ],
		'plugins' => [ 'cf7', 'rev', 'ele' ],
		'wrapper' => '1250',
	),
	'language4' => array(
		'name' => 'Language 4',
    'layouts' => [ 'lig', 'ele', 'mfn' ],
		'categories' => [ 'edu' ],
		'plugins' => [ 'cf7', 'rev', 'ele' ],
		'wrapper' => '1280',
	),
	'pregnancy' => array(
		'name' => 'Pregnancy',
    'layouts' => [ 'blo', 'lig', 'ele', 'mfn' ],
		'categories' => [ 'hea', 'peo', 'oth' ],
		'plugins' => [ 'cf7', 'ele' ],
		'wrapper' => '1260',
		'pages' => [
			'page_for_posts' => 'News', // do not change, blog page is not posts page in this demo
		],
	),
	'jeweler2' => array(
		'name' => 'Jeweler 2',
    'layouts' => [ 'sho', 'lig', 'ele', 'mfn' ],
		'categories' => [ 'fas', 'occ', 'pro' ],
		'plugins' => [ 'cf7', 'rev', 'woo', 'ele' ],
		'wrapper' => '1170',
		'pages' => [
			'woocommerce_shop_page_id' => 'Products',
		],
	),
	'coaching3' => array(
		'name' => 'Coaching 3',
    'layouts' => [ 'one', 'ele', 'mfn' ],
		'categories' => [ 'edu', 'peo' ],
		'plugins' => [ 'cf7', 'rev', 'ele' ],
		'wrapper' => '1170',
	),
	'lottie' => [
		'name' => 'Lottie',
		'layouts' => ['blo','lig','ele','mfn'],
		'categories' => ['des','cor','tec'],
		'plugins' => ['cf7','ele'],
		'wrapper' => '1230',
	],
	'accountant4' => [
		'name' => 'Accountant 4',
		'layouts' => ['ele','mfn'],
		'categories' => ['fin','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1260',
	],
	'itservice6' => [
		'name' => 'IT Service 6',
		'layouts' => ['ele','mfn'],
		'categories' => ['tec','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1300',
	],
	'personaltrainer3' => [
		'name' => 'Personal Trainer 3',
		'layouts' => ['one','dar','ele','mfn'],
		'categories' => ['hea','peo','spo'],
		'plugins' => ['cf7','ele'],
		'wrapper' => '1310',
	],
	'foodtruck2' => [
		'name' => 'Food Truck 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['foo','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1280',
	],
	'carrental3' => [
		'name' => 'Car Rental 3',
		'layouts' => ['lig','mob','ele','mfn'],
		'categories' => ['car','peo','spo'],
		'plugins' => ['cf7','ele'],
		'wrapper' => '1350',
	],
	'business5' => [
		'name' => 'Business 5',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['cor','hou'],
		'plugins' => ['cf7','ele'],
		'wrapper' => '1700',
	],
	'blogger4' => [
		'name' => 'Blogger 4',
		'layouts' => ['blo','lig','ele','mfn'],
		'categories' => ['des','ent','mag'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1240',
		'pages' => [
			'page_for_posts' => 'News',
		],
	],
	'landing4' => [
		'name' => 'Landing 4',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['des','cor','tec','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1160',
	],
	'event8' => [
		'name' => 'Event 8',
		'layouts' => ['dar','ele','mfn'],
		'categories' => ['ent','foo','occ'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1340',
	],
	'whiskey2' => [
		'name' => 'Whiskey 2',
		'layouts' => ['blo','sho','dar','ele','mfn'],
		'categories' => ['ent','foo','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1210',
		'pages' => [
			'page_for_posts' => 'News',
			'woocommerce_shop_page_id' => 'Products',
		],
	],
	'agency7' => [
		'name' => 'Agency 7',
		'layouts' => ['blo','sho','lig','ele','mfn'],
		'categories' => ['cor','tec','peo','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1140',
		'pages' => [
			'page_for_posts' => 'News',
		],
	],
	'book2' => [
		'name' => 'Book 2',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['ent','hea','mag','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1180',
	],
	'tire' => [
		'name' => 'Tire',
		'layouts' => ['ele','mfn'],
		'categories' => ['car','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1245',
	],
	'ecofood2' => [
		'name' => 'Eco Food 2',
		'layouts' => ['blo','sho','ele','mfn'],
		'categories' => ['foo','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1140',
		'pages' => [
			'page_for_posts' => 'News',
		],
	],
	'shopassistant' => [
		'name' => 'Shop Assistant',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1320',
		'pages' => [
			'page_for_posts' => 'News',
		],
	],
	'design4' => [
		'name' => 'Design 4',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['art','des','fas','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1160',
	],
	'wallet2' => [
		'name' => 'Wallet 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['cor','tec','fin'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1160',
	],
	'babyshop' => [
		'name' => 'Baby Shop',
		'layouts' => ['blo','sho','lig','ele','mfn'],
		'categories' => ['fas','peo','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1280',
		'pages' => [
			'woocommerce_shop_page_id' => 'Products<br /> Catalog',
		],
	],
	'event7' => [
		'name' => 'Event 7',
		'layouts' => ['ele','mfn'],
		'categories' => ['art','ent','occ'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1180',
	],
	'cottage3' => [
		'name' => 'Cottage 3',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['ani','foo','hou'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1150',
	],
	'franchise' => [
		'name' => 'Franchise',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['cor','foo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1170',
		'pages' => [
			'page_for_posts' => 'News',
		],
	],
	'dietshop' => [
		'name' => 'Diet Shop',
		'layouts' => ['blo','sho','lig','ele','mfn'],
		'categories' => ['foo','hea','peo','mag','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1280',
	],
	'agency6' => [
		'name' => 'Agency 6',
		'layouts' => ['por','dar','ele','mfn'],
		'categories' => ['des','cor','tec'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'nursinghome' => [
		'name' => 'Nursing Home',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['hea','peo','hou','oth'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1280',
	],
	'dentist4' => [
		'name' => 'Dentist 4',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['hea','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1260',
	],
	'event6' => [
		'name' => 'Event 6',
		'layouts' => ['ele','mfn'],
		'categories' => ['fas','occ'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1290',
	],
	'clothingstore' => [
		'name' => 'Clothing Store',
		'layouts' => ['blo','sho','lig','ele','mfn'],
		'categories' => ['fas','mag','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1180',
	],
	'business4' => [
		'name' => 'Business 4',
		'layouts' => ['ele','mfn'],
		'categories' => ['cor','fin','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1160',
	],
	'church3' => [
		'name' => 'Church 3',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['art'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1220',
		'pages' => [
			'page_for_posts' => 'GOOD NEWS',
		],
	],
	'flower2' => [
		'name' => 'Flower 2',
		'layouts' => ['sho','ele','mfn'],
		'categories' => ['occ','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1320',
		'pages' => [
			'woocommerce_shop_page_id' => 'Our flowers',
		],
	],
	'consultant2' => [
		'name' => 'Consultant 2',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['cor','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1150',
	],
	'cottage2' => [
		'name' => 'Cottage 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['hou'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'ebook3' => [
		'name' => 'eBook 3',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['mag'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1150',
	],
	'interior6' => [
		'name' => 'Interior 6',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['des','hou'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'tea4' => [
		'name' => 'Tea 4',
		'layouts' => ['sho','ele','mfn'],
		'categories' => ['foo','hou'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1140',
		'pages' => [
			'woocommerce_shop_page_id' => 'View our<br/>tea selections',
		],
	],
	'mechanic7' => [
		'name' => 'Mechanic 7',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['car','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1280',
	],
	'surfing2' => [
		'name' => 'Surfing 2',
		'layouts' => ['sho','ele','mfn'],
		'categories' => ['spo'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1140',
		'pages' => [
			'woocommerce_shop_page_id' => 'PRODUCTS',
		],
	],
	'hemp' => [
		'name' => 'Hemp',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['foo','hea','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1140',
		'pages' => [
			'woocommerce_shop_page_id' => 'Discover <br/>our products',
		],
	],
	'coworking' => [
		'name' => 'Coworking',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['cor','tec','peo','hou'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1340',
	],
	'pizza5' => [
		'name' => 'Pizza 5',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1340',
	],
	'baker3' => [
		'name' => 'Baker 3',
		'layouts' => ['ele','mfn'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'dietitian3' => [
		'name' => 'Dietitian 3',
		'layouts' => ['blo','lig','ele','mfn'],
		'categories' => ['foo','hea','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'itservice5' => [
		'name' => 'IT Service 5',
		'layouts' => ['ele','mfn'],
		'categories' => ['cor','tec','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1150',
	],
	'webmaster2' => [
		'name' => 'Webmaster 2',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['tec','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1160',
	],
	'internet3' => [
		'name' => 'Internet 3',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'cleaner3' => [
		'name' => 'Cleaner 3',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'history' => [
		'name' => 'History',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['des','edu','ent'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'funfair' => [
		'name' => 'Funfair',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['ent','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'barber4' => [
		'name' => 'Barber 4',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['fas','hea','peo'],
		'plugins' => ['cf7','ele'],
		'wrapper' => '1100',
	],
	'farm2' => [
		'name' => 'Farm 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['ani','foo','pro'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1160',
	],
	'industry2' => [
		'name' => 'Industry 2',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['cor','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1170',
	],
	'photography3' => [
		'name' => 'Photography 3',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['art','ani','des','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'print4' => [
		'name' => 'Print 4',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['des','peo','pro'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1200',
	],
	'kindergarten4' => [
		'name' => 'Kindergarten 4',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['edu','ent'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1110',
	],
	'finance4' => [
		'name' => 'Finance 4',
		'layouts' => ['ele','mfn'],
		'categories' => ['cor','fin','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1130',
	],
	'party4' => [
		'name' => 'Party 4',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['ent','occ'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1130',
	],
	'scooterrental' => [
		'name' => 'Scooter Rental',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['car','peo','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1280',
	],
	'landing3' => [
		'name' => 'Landing 3',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'portfolio2' => [
		'name' => 'Portfolio 2',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['des'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'factory3' => [
		'name' => 'Factory 3',
		'layouts' => ['ele','mfn'],
		'categories' => ['pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1100',
	],
	'weddingband' => [
		'name' => 'Wedding Band',
		'layouts' => ['blo'],
		'categories' => ['des','occ','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'spa6' => [
		'name' => 'Spa 6',
		'layouts' => ['ele','mfn'],
		'categories' => ['hea','peo','hou'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1260',
	],
	'corporation3' => [
		'name' => 'Corporation 3',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['cor','fin'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'pestcontrol' => [
		'name' => 'Pest Control',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['ani','tec','peo','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1260',
		'pages' => [
			'woocommerce_shop_page_id' => 'Our products',
		],
	],
	'handyman3' => [
		'name' => 'Handyman 3',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1260',
	],
	'media2' => [
		'name' => 'Media 2',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['des','cor','tec'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'ski2' => [
		'name' => 'Ski 2',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['peo','hou','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1260',
	],
	'travel2' => [
		'name' => 'Travel 2',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['ent','peo','spo'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1260',
		'pages' => [
			'woocommerce_shop_page_id' => 'Our tours<br /> and attractions',
		],
	],
	'carparts' => [
		'name' => 'Car Parts',
		'layouts' => ['sho','ele','mfn'],
		'categories' => ['car','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1260',
		'pages' => [
			'woocommerce_shop_page_id' => 'our products',
		],
	],
	'computershop' => [
		'name' => 'Computer Shop',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1260',
		'pages' => [
			'woocommerce_shop_page_id' => 'Our products',
		],
	],
	'leasing' => [
		'name' => 'Leasing',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['car','cor','fin','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1270',
	],
	'festival2' => [
		'name' => 'Festival 2',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['art','ent','occ'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1120',
	],
	'aromatherapy' => [
		'name' => 'Aromatherapy',
		'layouts' => ['ele','mfn'],
		'categories' => ['hea','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'gsmservice2' => [
		'name' => 'GSM Service 2',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['tec','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'agency5' => [
		'name' => 'Agency 5',
		'layouts' => ['por','lig','ele','mfn'],
		'categories' => ['des','cor'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'optics' => [
		'name' => 'Optics',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['fas','hea','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1120',
		'pages' => [
			'woocommerce_shop_page_id' => 'SHOP',
		],
	],
	'itservice4' => [
		'name' => 'IT Service 4',
		'layouts' => ['ele','mfn'],
		'categories' => ['tec','peo'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'firm2' => [
		'name' => 'Firm 2',
		'layouts' => ['box','lig','ele','mfn'],
		'categories' => ['cor','fin'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1000',
	],
	'finance3' => [
		'name' => 'Finance 3',
		'layouts' => ['ele','mfn'],
		'categories' => ['cor','fin'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1260',
	],
	'clinic5' => [
		'name' => 'Clinic 5',
		'layouts' => ['ele','mfn'],
		'categories' => ['hea','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1260',
	],
	'cv2' => [
		'name' => 'CV 2',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['peo'],
		'plugins' => ['rev','ele',
		],
	],
	'creative4' => [
		'name' => 'Creative 4',
		'layouts' => ['blo','por','lig','ele','mfn'],
		'categories' => ['des','cor','tec'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1920',
	],
	'bistro4' => [
		'name' => 'Bistro 4',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['foo','peo'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1120',
	],
	'records2' => [
		'name' => 'Records 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['art','ent'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'home3' => [
		'name' => 'Home 3',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['des','hou','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1120',
		'pages' => [
			'woocommerce_shop_page_id' => 'Our products',
		],
	],
	'hairdresser3' => [
		'name' => 'Hairdresser 3',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['hea','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'clothing2' => [
		'name' => 'Clothing 2',
		'layouts' => ['sho','ele','lig','mfn'],
		'categories' => ['fas','hea','pro'],
		'plugins' => ['cf7','rev','woo','ele',
		],
	],
	'store2' => [
		'name' => 'Store 2',
		'layouts' => ['blo','sho','ele','lig','mfn'],
		'categories' => ['fas'],
		'plugins' => ['cf7','rev','woo','ele'],
		'pages' => [
			'woocommerce_shop_page_id' => 'Products',
		],
	],
	'event5' => [
		'name' => 'Event 5',
		'layouts' => ['ele','mfn'],
		'categories' => ['art','cor','edu','occ'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'restaurant7' => [
		'name' => 'Restaurant 7',
		'layouts' => ['ele','mfn'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1180',
	],
	'mechanic6' => [
		'name' => 'Mechanic 6',
		'layouts' => ['ele','mfn'],
		'categories' => ['car','peo'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'model3' => [
		'name' => 'Model 3',
		'layouts' => ['por','dar','ele','mfn'],
		'categories' => ['des','fas'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'detailing4' => [
		'name' => 'Detailing 4',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['car','peo'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'clinic4' => [
		'name' => 'Clinic 4',
		'layouts' => ['ele','mfn'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'personaltrainer2' => [
		'name' => 'Personal Trainer 2',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['peo','spo'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'charity3' => [
		'name' => 'Charity 3',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['cor','occ','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'business3' => [
		'name' => 'Business 3',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['cor','fin','peo'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'data' => [
		'name' => 'Data',
		'layouts' => ['ele','mfn'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'developer4' => [
		'name' => 'Developer 4',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['hou','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'artist3' => [
		'name' => 'Artist 3',
		'layouts' => ['sho','ele','mfn'],
		'categories' => ['art','des'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1120',
	],
	'corporation2' => [
		'name' => 'Corporation 2',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['cor'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'barman2' => [
		'name' => 'Barman 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['edu','ent','foo','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'home2' => [
		'name' => 'Home 2',
		'layouts' => ['sho','ele','mfn'],
		'categories' => ['des','hou'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1120',
		'pages' => [
			'woocommerce_shop_page_id' => 'Products',
		],
	],
	'erp2' => [
		'name' => 'ERP 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['cor','tec'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'course2' => [
		'name' => 'Course 2',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['edu','tec'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'training2' => [
		'name' => 'Training 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['edu','tec','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'agency4' => [
		'name' => 'Agency 4',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['cor','tec','peo'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'massage2' => [
		'name' => 'Massage 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['hea','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'ai' => [
		'name' => 'AI',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['edu','tec'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'grocery2' => [
		'name' => 'Grocery 2',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['foo','hea'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1280',
		'pages' => [
			'woocommerce_shop_page_id' => '○ Our products',
		],
	],
	'party3' => [
		'name' => 'Party 3',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['ent','occ'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1260',
	],
	'mining2' => [
		'name' => 'Mining 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['cor','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'app7' => [
		'name' => 'App 7',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['tec','hea','spo'],
		'plugins' => ['rev','ele',
		],
	],
	'loans4' => [
		'name' => 'Loans 4',
		'layouts' => ['ele','mfn'],
		'categories' => ['fin'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'renovate4' => [
		'name' => 'Renovate 4',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'estate3' => [
		'name' => 'Estate 3',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['hou'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'consultant' => [
		'name' => 'Consultant',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['cor','fin','peo'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'finance2' => [
		'name' => 'Finance 2',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['cor','fin'],
		'plugins' => ['cf7','rev','ele',
		],
	],
	'firebrigade' => [
		'name' => 'Fire Brigade',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['cor','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'craftbeer2' => [
		'name' => 'Craft Beer 2',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['foo','oth'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1100',
	],
	'lab3' => [
		'name' => 'Lab 3',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['edu','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'medicalshop2' => [
		'name' => 'Medical Shop 2',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['hea','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1120',
		'pages' => [
			'woocommerce_shop_page_id' => 'Our products',
		],
	],
	'psychologist3' => [
		'name' => 'Psychologist 3',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['hea','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'politics2' => [
		'name' => 'Politics 2',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['cor'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'medicalshop' => [
		'name' => 'Medical Shop',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['hea','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1120',
		'pages' => [
			'woocommerce_shop_page_id' => 'OUR PRODUCTS',
		],
	],
	'course' => [
		'name' => 'Course',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['art','des','edu'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'grocery' => [
		'name' => 'Grocery',
		'layouts' => ['sho','ele','mfn'],
		'categories' => ['foo','hea'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1120',
		'pages' => [
			'woocommerce_shop_page_id' => 'Products',
		],
	],
	'product5' => [
		'name' => 'Product 5',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['hea'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1120',
	],
	'restaurant6' => [
		'name' => 'Restaurant 6',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1160',
	],
	'wine3' => [
		'name' => 'Wine 3',
		'layouts' => ['ele','mfn'],
		'categories' => ['foo','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'copywriter2' => [
		'name' => 'Copywriter 2',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['peo','mag'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'pay2' => [
		'name' => 'Pay 2',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['tec','fin'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'company6' => [
		'name' => 'Company 6',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['cor','des'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'weddingservices' => [
		'name' => 'Wedding Services',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['des','ent','occ','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'astrology' => [
		'name' => 'Astrology',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['peo','oth'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'journey2' => [
		'name' => 'Journey 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'loans3' => [
		'name' => 'Loans 3',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['fin'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1120',
	],
	'cafe3' => [
		'name' => 'Cafe 3',
		'layouts' => ['ele','mfn'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'band5' => [
		'name' => 'Band 5',
		'layouts' => ['dar','ele','mfn'],
		'categories' => ['art','ent'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'hotel5' => [
		'name' => 'Hotel 5',
		'layouts' => ['ele','mfn'],
		'categories' => ['foo','hou','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'rallydriver' => [
		'name' => 'Rally Driver',
		'layouts' => ['dar','ele','mfn'],
		'categories' => ['car','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'foodtruck' => [
		'name' => 'Food Truck',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['foo'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1120',
	],
	'mall' => [
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['ent','fas','oth'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'psychologist2' => [
		'name' => 'Psychologist 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['hea','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'handyman2' => [
		'name' => 'Handyman 2',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['hou','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'security3' => [
		'name' => 'Security 3',
		'layouts' => ['dar','ele','mfn'],
		'categories' => ['cor','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'club3' => [
		'name' => 'Club 3',
		'layouts' => ['blo','dar','ele','mfn'],
		'categories' => ['art','ent'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'restaurant5' => [
		'name' => 'Restaurant 5',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['foo'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1140',
	],
	'tailor3' => [
		'name' => 'Tailor 3',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['fas','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'itservice3' => [
		'name' => 'IT Service 3',
		'layouts' => ['ele','mfn'],
		'categories' => ['tec','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'app6' => [
		'name' => 'App 6',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['tec'],
		'plugins' => ['ele'],
		'wrapper' => '1120',
	],
	'swimmingpool' => [
		'name' => 'Swimming Pool',
		'layouts' => ['ele','mfn'],
		'categories' => ['ent','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'tutor' => [
		'layouts' => ['lig','blo','ele','mfn'],
		'categories' => ['edu'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'carrental2' => [
		'name' => 'Car Rental 2',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['car'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'interactive2' => [
		'name' => 'Interactive 2',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['des','tec'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'cityhall' => [
		'name' => 'City Hall',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['art','occ','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'electric2' => [
		'name' => 'Electric 2',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['tec','peo','hou'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1120',
	],
	'band4' => [
		'name' => 'Band 4',
		'layouts' => ['ele','mfn'],
		'categories' => ['art','ent'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'weddingplanner' => [
		'name' => 'Wedding Planner',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['occ','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'steak2' => [
		'name' => 'Steak 2',
		'layouts' => ['dar','ele','mfn'],
		'categories' => ['foo','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'ecofood' => [
		'name' => 'Eco Food',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['foo','hea','pro'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1160',
		'pages' => [
			'woocommerce_shop_page_id' => 'Products',
		],
	],
	'danceschool2' => [
		'name' => 'Dance School 2',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['art','ent','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'fisher' => [
		'layouts' => ['ele','mfn'],
		'categories' => ['spo','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'eco3' => [
		'name' => 'Eco 3',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'xmas3' => [
		'name' => 'Xmas 3',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['occ'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'language3' => [
		'name' => 'Language 3',
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['edu'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'repair3' => [
		'name' => 'Repair 3',
		'layouts' => ['por','ele','mfn'],
		'categories' => ['tec','peo','hou'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'kindergarten3' => [
		'name' => 'Kindergarten 3',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['edu','ent'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'3dprint' => [
		'name' => '3D Print',
		'layouts' => ['sho','lig','ele','mfn'],
		'categories' => ['edu','tec'],
		'plugins' => ['cf7','rev','woo','ele'],
		'wrapper' => '1120',
	],
	'horse2' => [
		'name' => 'Horse 2',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['ani','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'party2' => [
		'name' => 'Party 2',
		'layouts' => ['one','dar','ele','mfn'],
		'categories' => ['ent','occ'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1200',
	],
	'callcenter2' => [
		'name' => 'Call Center 2',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['cor'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'spa5' => [
		'name' => 'Spa 5',
		'layouts' => ['ele','mfn'],
		'categories' => ['ent','hea'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1260',
	],
	'plumber2' => [
		'name' => 'Plumber 2',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'blogger3' => [
		'name' => 'Blogger 3',
		'layouts' => ['blo'],
		'categories' => ['spo','mag'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1000',
	],
	'driving2' => [
		'name' => 'Driving 2',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['car','edu'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'oculist2' => [
		'name' => 'Oculist 2',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'coach' => [
		'layouts' => ['ele','mfn'],
		'categories' => ['car','peo','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'halloween' => [
		'layouts' => ['one','dar','ele','mfn'],
		'categories' => ['art','occ'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'icecream2' => [
		'name' => 'Ice Cream 2',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'paintball' => [
		'layouts' => ['ele','mfn'],
		'categories' => ['ent','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'carwash2' => [
		'name' => 'Car Wash 2',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['car','peo'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1120',
	],
	'insurance3' => [
		'name' => 'Insurance 3',
		'layouts' => ['blo','lig','ele','mfn'],
		'categories' => ['cor','fin','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'transport3' => [
		'name' => 'Transport 3',
		'layouts' => ['ele','mfn'],
		'categories' => ['car','cor','peo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'lawyer5' => [
		'name' => 'Lawyer 5',
		'layouts' => ['blo','dar','ele','mfn'],
		'categories' => ['peo'],
		'plugins' => ['cf7','ele'],
		'wrapper' => '1120',
	],
	'seo3' => [
		'name' => 'SEO 3',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'spa4' => [
		'name' => 'Spa 4',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1160',
	],
	'hosting3' => [
		'name' => 'Hosting 3',
		'layouts' => ['dar','ele','mfn'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'video3' => [
		'name' => 'Video 3',
		'layouts' => ['dar','ele','mfn'],
		'categories' => ['art','des','ent'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1140',
	],
	'marathon' => [
		'layouts' => ['one','ele','mfn'],
		'categories' => ['ent','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'taxi2' => [
		'name' => 'Taxi 2',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['car','peo'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1120',
	],
	'boxing' => [
		'layouts' => ['dar','ele','mfn'],
		'categories' => ['ent','spo'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'webinar' => [
		'layouts' => ['blo','ele','mfn'],
		'categories' => ['edu'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'factory2' => [
		'name' => 'Factory 2',
		'layouts' => ['ele','mfn'],
		'categories' => ['pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1100',
	],
	'seajourney' => [
		'name' => 'Sea Journey',
		'layouts' => ['one','lig','ele','mfn'],
		'categories' => ['peo','spo'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1120',
	],
	'print3' => [
		'name' => 'Print 3',
		'layouts' => ['por','lig','ele','mfn'],
		'categories' => ['des','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'app5' => [
		'name' => 'App 5',
		'layouts' => ['one','ele','mfn'],
		'categories' => ['tec','spo'],
		'plugins' => ['rev','ele'],
		'wrapper' => '1120',
	],
	'biker3' => [
		'name' => 'Biker 3',
		'layouts' => ['ele','mfn'],
		'categories' => ['peo','spo','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1120',
	],
	'honey' => [
		'layouts' => ['ele','mfn'],
		'categories' => ['ani','peo','pro'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1160',
	],
	'cleaner2' => [
		'name' => 'Cleaner 2',
		'layouts' => ['lig','ele','mfn'],
		'categories' => ['hou'],
		'plugins' => ['cf7','rev','ele'],
		'wrapper' => '1110',
	],
	'ebook2' => [
		'name' => 'eBook 2',
		'layouts' => ['one','dar'],
		'categories' => ['art','ent','mag'],
		'plugins' => ['rev',
		],
	],
	'festival' => [
		'layouts' => ['one'],
		'categories' => ['art','ent','occ'],
		'plugins' => ['cf7','rev',
		],
	],
	'garden4' => [
		'name' => 'Garden 4',
		'layouts' => ['por'],
		'categories' => ['ani','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'football2' => [
		'name' => 'Football 2',
		'layouts' => ['blo'],
		'categories' => ['spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'architect5' => [
		'name' => 'Architect 5',
		'layouts' => ['por'],
		'categories' => ['art','cor','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'cottage' => [
		'categories' => ['hou','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'company5' => [
		'name' => 'Company 5',
		'categories' => ['cor'],
		'plugins' => ['cf7','rev',
		],
	],
	'catering2' => [
		'name' => 'Catering 2',
		'layouts' => ['one'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'dj2' => [
		'name' => 'DJ 2',
		'layouts' => ['blo','por'],
		'categories' => ['art','ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'photography2' => [
		'name' => 'Photography 2',
		'layouts' => ['por','dar'],
		'categories' => ['des','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'code2' => [
		'name' => 'Code 2',
		'categories' => ['tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'bar3' => [
		'name' => 'Bar 3',
		'categories' => ['ent','foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'dentist3' => [
		'name' => 'Dentist 3',
		'layouts' => ['lig'],
		'categories' => ['hea','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'event4' => [
		'name' => 'Event 4',
		'layouts' => ['one','lig'],
		'categories' => ['art','occ'],
		'plugins' => ['rev',
		],
	],
	'sitter2' => [
		'name' => 'Sitter 2',
		'layouts' => ['one','lig'],
		'categories' => ['edu','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'design3' => [
		'name' => 'Design 3',
		'layouts' => ['one'],
		'categories' => ['des'],
		'plugins' => ['cf7','rev',
		],
	],
	'photo2' => [
		'name' => 'Photo 2',
		'layouts' => ['por','dar'],
		'categories' => ['des','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'psychologist' => [
		'categories' => ['hea','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'hotel4' => [
		'name' => 'Hotel 4',
		'layouts' => ['lig'],
		'categories' => ['foo','peo','hou'],
		'plugins' => ['cf7',
		],
	],
	'gym3' => [
		'name' => 'Gym 3',
		'categories' => ['hea','peo','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'yoga3' => [
		'name' => 'Yoga 3',
		'categories' => ['hea','peo','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'lab2' => [
		'name' => 'Lab 2',
		'categories' => ['edu','hea','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'pizza4' => [
		'name' => 'Pizza 4',
		'layouts' => ['box'],
		'categories' => ['ent','foo','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'mechanic5' => [
		'name' => 'Mechanic 5',
		'layouts' => ['one'],
		'categories' => ['car','peo'],
		'plugins' => ['rev',
		],
	],
	'medic3' => [
		'name' => 'Medic 3',
		'layouts' => ['lig'],
		'categories' => ['cor','edu','hea','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'barber3' => [
		'name' => 'Barber 3',
		'categories' => ['fas','hea','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'itservice2' => [
		'name' => 'IT Service 2',
		'categories' => ['tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'transport2' => [
		'name' => 'Transport 2',
		'layouts' => ['one'],
		'categories' => ['car'],
		'plugins' => ['rev',
		],
	],
	'mechanic4' => [
		'name' => 'Mechanic 4',
		'layouts' => ['one'],
		'categories' => ['car','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'yacht' => [
		'categories' => ['ent','spo'],
		'plugins' => ['cf7',
		],
	],
  'safari2' => [
		'name' => 'Safari 2',
		'layouts' => ['blo'],
		'categories' => ['ani','ent','spo'],
		'plugins' => ['cf7','rev'],
    'pages' => [
			'page_for_posts' => 'OUR TRAVELS',
		],
	],
	'baker2' => [
		'name' => 'Baker 2',
		'layouts' => ['one'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'hairdresser2' => [
		'name' => 'Hairdresser 2',
		'categories' => ['fas','hea','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'mountainguide' => [
		'name' => 'Mountain Guide',
		'categories' => ['ani','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'extreme2' => [
		'name' => 'Extreme 2',
		'categories' => ['ani','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'event3' => [
		'name' => 'Event 3',
		'layouts' => ['one'],
		'categories' => ['edu','tec','occ'],
		'plugins' => ['rev',
		],
	],
	'product4' => [
		'name' => 'Product 4',
		'layouts' => ['one'],
		'categories' => ['edu','tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'resort2' => [
		'name' => 'Resort 2',
		'categories' => ['foo','hou','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'bistro3' => [
		'name' => 'Bistro 3',
		'layouts' => ['one'],
		'categories' => ['foo','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'danceschool' => [
		'name' => 'Dance School',
		'categories' => ['art','ent','spo'],
		'plugins' => ['cf7','rev',
		],
	],
  'sciencecentre' => [
		'name' => 'Science Centre',
		'layouts' => ['blo'],
		'categories' => ['edu','occ'],
		'plugins' => ['cf7'],
    'pages' => [
			'page_for_posts' => 'News and events',
		],
	],
	'polyglot' => [
		'categories' => ['cor','edu'],
		'plugins' => ['cf7','rev',
		],
	],
	'interior5' => [
		'name' => 'Interior 5',
		'layouts' => ['por'],
		'categories' => ['des','hou'],
		'plugins' => ['rev',
		],
	],
	'carpenter4' => [
		'name' => 'Carpenter 4',
		'categories' => ['des','peo','hou','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'company4' => [
		'name' => 'Company 4',
		'layouts' => ['one','lig'],
		'categories' => ['cor','tec'],
		'plugins' => ['rev',
		],
	],
	'club2' => [
		'name' => 'Club 2',
		'layouts' => ['blo'],
		'categories' => ['art','ent','occ'],
		'plugins' => ['cf7','rev',
		],
	],
	'adventure2' => [
		'name' => 'Adventure 2',
		'layouts' => ['lig'],
		'categories' => ['ani','ent','spo'],
		'plugins' => ['cf7',
		],
	],
	'whiskey' => [
		'categories' => ['cor','ent','foo','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'product3' => [
		'name' => 'Product 3',
		'layouts' => ['one'],
		'categories' => ['des','cor','fas'],
		'plugins' => ['cf7','rev',
		],
	],
	'organic' => [
		'layouts' => ['blo','lig'],
		'categories' => ['foo','peo','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'moving3' => [
		'name' => 'Moving 3',
		'layouts' => ['one'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'architect4' => [
		'name' => 'Architect 4',
		'layouts' => ['por'],
		'categories' => ['hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'electronics' => [
		'layouts' => ['blo'],
		'categories' => ['tec','peo'],
		'plugins' => ['cf7',
		],
	],
	'tea3' => [
		'name' => 'Tea 3',
		'layouts' => ['one'],
		'categories' => ['foo','pro'],
		'plugins' => ['rev',
		],
	],
	'hosting2' => [
		'name' => 'Hosting 2',
		'layouts' => ['lig'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'coaching2' => [
		'name' => 'Coaching 2',
		'categories' => ['edu'],
		'plugins' => ['cf7','rev',
		],
	],
	'product2' => [
		'name' => 'Product 2',
		'layouts' => ['one'],
		'categories' => ['fas','hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'healthy' => [
		'layouts' => ['lig'],
		'categories' => ['hea','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'diet2' => [
		'name' => 'Diet 2',
		'layouts' => ['por','lig'],
		'categories' => ['foo','hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'biker2' => [
		'name' => 'Biker 2',
		'categories' => ['peo','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'app4' => [
		'name' => 'App 4',
		'layouts' => ['one'],
		'categories' => ['cor','ent'],
		'plugins' => ['rev',
		],
	],
	'carpenter3' => [
		'name' => 'Carpenter 3',
		'layouts' => ['por'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'video2' => [
		'name' => 'Video 2',
		'layouts' => ['por','dar'],
		'categories' => ['des','ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'manicure2' => [
		'name' => 'Manicure 2',
		'layouts' => ['one'],
		'categories' => ['fas','hea','peo',
		],
	],
	'adagency2' => [
		'name' => 'AdAgency 2',
		'layouts' => ['por'],
		'categories' => ['des','cor'],
		'plugins' => ['cf7',
		],
	],
	'print2' => [
		'name' => 'Print 2',
		'layouts' => ['por'],
		'categories' => ['des','mag','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'pet' => [
		'layouts' => ['one'],
		'categories' => ['ani','ent','mag'],
		'plugins' => ['cf7','rev',
		],
	],
	'weddingphotos' => [
		'name' => 'Wedding Photos',
		'layouts' => ['por'],
		'categories' => ['des','occ','peo'],
		'plugins' => ['cf7',
		],
	],
	'restaurant4' => [
		'name' => 'Restaurant 4',
		'layouts' => ['blo'],
		'categories' => ['ent','foo','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'catering' => [
		'categories' => ['foo','occ','peo'],
		'plugins' => ['cf7',
		],
	],
	'aeroclub' => [
		'name' => 'Aero Club',
		'layouts' => ['blo'],
		'categories' => ['cor','ent','spo'],
		'plugins' => ['rev',
		],
	],
	'logistics2' => [
		'name' => 'Logistics 2',
		'categories' => ['car'],
		'plugins' => ['cf7',
		],
	],
	'cosmetics2' => [
		'name' => 'Cosmetics 2',
		'categories' => ['cor','hea','pro'],
		'plugins' => ['rev',
		],
	],
	'kids' => [
		'categories' => ['edu','ent','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'asg2' => [
		'name' => 'ASG 2',
		'layouts' => ['dar'],
		'categories' => ['cor','ent','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'beauty4' => [
		'name' => 'Beauty 4',
		'categories' => ['fas','hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'model2' => [
		'name' => 'Model 2',
		'layouts' => ['por'],
		'categories' => ['des','fas'],
		'plugins' => ['cf7','rev',
		],
	],
	'weddingdresses' => [
		'name' => 'Wedding Dresses',
		'categories' => ['fas','occ'],
		'plugins' => ['cf7','rev',
		],
	],
	'spa3' => [
		'name' => 'Spa 3',
		'categories' => ['ent','hea','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'band3' => [
		'name' => 'Band 3',
		'layouts' => ['dar'],
		'categories' => ['art','ent','occ'],
		'plugins' => ['cf7',
		],
	],
	'gunrange' => [
		'name' => 'Gun Range',
		'layouts' => ['one'],
		'categories' => ['spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'renovate3' => [
		'name' => 'Renovate 3',
		'layouts' => ['por'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'tailor2' => [
		'name' => 'Tailor 2',
		'layouts' => ['lig'],
		'categories' => ['fas','peo'],
		'plugins' => ['rev',
		],
	],
	'cakes' => [
		'layouts' => ['one'],
		'categories' => ['foo','peo','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'car2' => [
		'name' => 'Car 2',
		'layouts' => ['por'],
		'categories' => ['car','peo','pro'],
		'plugins' => ['rev',
		],
	],
	'agency3' => [
		'name' => 'Agency 3',
		'layouts' => ['lig'],
		'categories' => ['cor','tec'],
		'plugins' => ['cf7',
		],
	],
	'coffee3' => [
		'name' => 'Coffee 3',
		'categories' => ['cor','foo','pro'],
		'plugins' => ['rev',
		],
	],
	'school2' => [
		'name' => 'School 2',
		'categories' => ['edu'],
		'plugins' => ['cf7','rev',
		],
	],
	'burger2' => [
		'name' => 'Burger 2',
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'internet2' => [
		'name' => 'Internet 2',
		'categories' => ['tec','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'restaurant3' => [
		'name' => 'Restaurant 3',
		'categories' => ['foo'],
		'plugins' => ['cf7',
		],
	],
	'clinic3' => [
		'name' => 'Clinic 3',
		'categories' => ['cor','hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'drone' => [
		'layouts' => ['one','box'],
		'categories' => ['des','spo','pro'],
		'plugins' => ['rev',
		],
	],
	'estate2' => [
		'name' => 'Estate 2',
		'layouts' => ['por'],
		'categories' => ['fin','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'builder2' => [
		'name' => 'Builder 2',
		'layouts' => ['por'],
		'categories' => ['cor','hou','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'football' => [
		'layouts' => ['blo'],
		'categories' => ['ent','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'insurance2' => [
		'name' => 'Insurance 2',
		'layouts' => ['lig'],
		'categories' => ['cor','fin'],
		'plugins' => ['cf7','rev',
		],
	],
	'beauty3' => [
		'name' => 'Beauty 3',
		'categories' => ['hea','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'interior4' => [
		'name' => 'Interior 4',
		'layouts' => ['por'],
		'categories' => ['des','peo','hou'],
		'plugins' => ['rev',
		],
	],
	'recipes2' => [
		'name' => 'Recipes 2',
		'layouts' => ['blo'],
		'categories' => ['foo','mag',
		],
	],
	'erp' => [
		'layouts' => ['lig'],
		'categories' => ['cor','tec','pro',
		],
	],
	'lawyer4' => [
		'name' => 'Lawyer 4',
		'categories' => ['fin','peo'],
		'plugins' => ['cf7',
		],
	],
	'movie2' => [
		'name' => 'Movie 2',
		'layouts' => ['blo'],
		'categories' => ['art','des','ent','mag',
		],
	],
	'interior3' => [
		'name' => 'Interior 3',
		'layouts' => ['por'],
		'categories' => ['des','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'navigation' => [
		'layouts' => ['sho'],
		'categories' => ['cor','edu','tec','pro'],
		'plugins' => ['cf7','rev','woo'],
		'pages' => [
			'woocommerce_shop_page_id' => 'Store',
		],
	],
	'vet2' => [
		'name' => 'Vet 2',
		'layouts' => ['box'],
		'categories' => ['ani','hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'minimal2' => [
		'name' => 'Minimal 2',
		'categories' => ['art','des','cor','oth'],
		'plugins' => ['cf7','rev',
		],
	],
	'creative3' => [
		'name' => 'Creative 3',
		'layouts' => ['por'],
		'categories' => ['des','cor'],
		'plugins' => ['cf7',
		],
	],
	'county' => [
		'layouts' => ['blo'],
		'categories' => ['art','spo'],
		'plugins' => ['cf7',
		],
	],
	'company3' => [
		'name' => 'Company 3',
		'layouts' => ['por','lig'],
		'categories' => ['des','cor','tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'band2' => [
		'name' => 'Band 2',
		'categories' => ['art','ent'],
		'plugins' => ['cf7',
		],
	],
	'product' => [
		'categories' => ['foo','hea','spo','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'cryptocurrency' => [
		'layouts' => ['blo'],
		'categories' => ['tec','fin'],
		'plugins' => ['cf7','rev',
		],
	],
	'landing2' => [
		'name' => 'Landing 2',
		'layouts' => ['one'],
		'categories' => ['tec','fin'],
		'plugins' => ['cf7',
		],
	],
	'supplier' => [
		'categories' => ['car','cor'],
		'plugins' => ['cf7',
		],
	],
	'sportsman' => [
		'layouts' => ['blo'],
		'categories' => ['hea','spo'],
		'plugins' => ['cf7',
		],
	],
	'barman' => [
		'categories' => ['ent','foo','peo'],
		'plugins' => ['cf7',
		],
	],
	'kindergarten2' => [
		'name' => 'Kindergarten 2',
		'layouts' => ['blo'],
		'categories' => ['edu','ent','peo'],
		'plugins' => ['cf7',
		],
	],
	'coffee2' => [
		'name' => 'Coffee 2',
		'layouts' => ['blo'],
		'categories' => ['foo','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'gym2' => [
		'name' => 'Gym 2',
		'categories' => ['hea','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'eco2' => [
		'name' => 'Eco 2',
		'categories' => ['cor','tec','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'garden3' => [
		'name' => 'Garden 3',
		'layouts' => ['por'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'fantasy' => [
		'layouts' => ['dar'],
		'categories' => ['ent','pro','oth'],
		'plugins' => ['rev',
		],
	],
	'church2' => [
		'name' => 'Church 2',
		'layouts' => ['blo'],
		'categories' => ['art'],
		'plugins' => ['cf7','rev',
		],
	],
	'funeralhome' => [
		'name' => 'Funeral Home',
		'layouts' => ['one'],
		'categories' => ['occ','peo'],
		'plugins' => ['cf7',
		],
	],
	'security2' => [
		'name' => 'Security 2',
		'categories' => ['cor','peo','oth'],
		'plugins' => ['cf7','rev',
		],
	],
	'event2' => [
		'name' => 'Event 2',
		'layouts' => ['blo'],
		'categories' => ['art','ent','occ'],
		'plugins' => ['cf7','rev',
		],
	],
	'repair2' => [
		'name' => 'Repair 2',
		'layouts' => ['por'],
		'categories' => ['tec','peo','hou'],
		'plugins' => ['cf7',
		],
	],
	'thriller' => [
		'layouts' => ['one','dar'],
		'categories' => ['art','ent',
		],
	],
	'company2' => [
		'name' => 'Company 2',
		'layouts' => ['blo'],
		'categories' => ['cor'],
		'plugins' => ['cf7',
		],
	],
	'simple2' => [
		'name' => 'Simple 2',
		'categories' => ['des','oth'],
		'plugins' => ['cf7',
		],
	],
	'architect3' => [
		'name' => 'Architect 3',
		'layouts' => ['por'],
		'categories' => ['des','peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'adventure' => [
		'layouts' => ['blo','sho'],
		'categories' => ['ani','ent','spo','pro'],
		'plugins' => ['cf7','rev','woo'],
		'pages' => [
			'page_for_posts' => 'Adventure Stories',
		],
	],
  'accountant3' => [
		'name' => 'Accountant 3',
		'layouts' => ['blo'],
		'categories' => ['fin','peo'],
		'plugins' => ['cf7','rev'],
    'pages' => [
			'page_for_posts' => 'Articles',
		],
	],
	'universe' => [
		'layouts' => ['one'],
		'categories' => ['edu','tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'tea2' => [
		'name' => 'Tea 2',
		'layouts' => ['one','lig'],
		'categories' => ['foo','pro'],
		'plugins' => ['cf7',
		],
	],
	'hairdresser' => [
		'layouts' => ['one'],
		'categories' => ['fas','hea','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'mechanic3' => [
		'name' => 'Mechanic 3',
		'categories' => ['car','tec','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'fitness2' => [
		'name' => 'Fitness 2',
		'categories' => ['hea','spo'],
		'plugins' => ['cf7',
		],
	],
	'actor' => [
		'categories' => ['art','ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'clothing' => [
		'layouts' => ['sho'],
		'categories' => ['des','fas','pro'],
		'plugins' => ['cf7','rev','woo'],
		'revslider' => ['clothing.zip','clothing-content.zip',
		],
	],
	'dietitian2' => [
		'name' => 'Dietitian 2',
		'layouts' => ['one'],
		'categories' => ['foo','hea','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'resort' => [
		'categories' => ['ent','foo','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'bar2' => [
		'name' => 'Bar 2',
		'categories' => ['ent','foo','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'museum2' => [
		'name' => 'Museum 2',
		'layouts' => ['blo'],
		'categories' => ['art','ent'],
		'plugins' => ['cf7',
		],
	],
	'accountant2' => [
		'name' => 'Accountant 2',
		'layouts' => ['blo','box'],
		'categories' => ['fin','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'decor2' => [
		'name' => 'Decor 2',
		'layouts' => ['por','lig'],
		'categories' => ['des','hou'],
		'plugins' => ['cf7',
		],
	],
	'farm' => [
		'categories' => ['ani','tec','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'yoga2' => [
		'name' => 'Yoga 2',
		'categories' => ['hea','spo'],
		'plugins' => ['rev',
		],
	],
	'webdeveloper' => [
		'name' => 'Web Developer',
		'layouts' => ['por'],
		'categories' => ['tec','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'lawyer3' => [
		'name' => 'Lawyer 3',
		'categories' => ['cor','fin','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'birthday' => [
		'layouts' => ['one'],
		'categories' => ['ent','occ'],
		'plugins' => ['rev',
		],
	],
	'ecobeef' => [
		'name' => 'Eco Beef',
		'layouts' => ['blo'],
		'categories' => ['ani','foo','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'hotel3' => [
		'name' => 'Hotel 3',
		'layouts' => ['box'],
		'categories' => ['foo','hou','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'app3' => [
		'name' => 'App 3',
		'layouts' => ['lig'],
		'categories' => ['des','cor','tec','pro',
		],
	],
	'photography' => [
		'layouts' => ['blo','por'],
		'categories' => ['des','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'robotics' => [
		'categories' => ['cor','edu','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'carwash' => [
		'name' => 'Car Wash',
		'layouts' => ['box'],
		'categories' => ['car','oth'],
		'plugins' => ['cf7','rev',
		],
	],
	'gsmservice' => [
		'name' => 'GSM Service',
		'layouts' => ['one'],
		'categories' => ['tec','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'snowpark' => [
		'categories' => ['ent','foo','hou','spo'],
		'plugins' => ['rev',
		],
	],
	'wanderer' => [
		'layouts' => ['blo'],
		'categories' => ['ani','spo','mag'],
		'plugins' => ['rev',
		],
	],
	'pizza3' => [
		'name' => 'Pizza 3',
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'cv' => [
		'layouts' => ['one'],
		'categories' => ['peo','oth',
		],
	],
	'winter' => [
		'layouts' => ['box'],
		'categories' => ['peo','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'stylist' => [
		'layouts' => ['blo'],
		'categories' => ['fas','peo','pro'],
		'plugins' => ['cf7',
		],
	],
	'company' => [
		'layouts' => ['blo'],
		'categories' => ['cor','tec','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'bistro2' => [
		'name' => 'Bistro 2',
		'categories' => ['foo'],
		'plugins' => ['cf7',
		],
	],
	'music2' => [
		'name' => 'Music 2',
		'layouts' => ['blo','sho'],
		'categories' => ['art','ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'language2' => [
		'name' => 'Language 2',
		'layouts' => ['blo','lig'],
		'categories' => ['edu'],
		'plugins' => ['cf7','rev',
		],
	],
	'employment' => [
		'layouts' => ['blo'],
		'categories' => ['cor'],
		'plugins' => ['cf7','rev',
		],
	],
	'watchmaker' => [
		'layouts' => ['one'],
		'categories' => ['fas','peo','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'pay' => [
		'layouts' => ['dar'],
		'categories' => ['fin'],
		'plugins' => ['cf7',
		],
	],
	'animals2' => [
		'name' => 'Animals 2',
		'categories' => ['ani','ent'],
		'plugins' => ['cf7',
		],
	],
	'artist2' => [
		'name' => 'Artist 2',
		'layouts' => ['blo','por','lig'],
		'categories' => ['art','des'],
		'plugins' => ['cf7','rev',
		],
	],
	'developer3' => [
		'name' => 'Developer 3',
		'categories' => ['hou','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'personaltrainer' => [
		'name' => 'Personal Trainer',
		'layouts' => ['one'],
		'categories' => ['peo','spo'],
		'plugins' => ['cf7',
		],
	],
	'detailing3' => [
		'name' => 'Detailing 3',
		'categories' => ['car'],
		'plugins' => ['cf7',
		],
	],
	'carpenter2' => [
		'name' => 'Carpenter 2',
		'categories' => ['des','hou','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'internet' => [
		'layouts' => ['blo','lig'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'airport' => [
		'layouts' => ['blo'],
		'categories' => ['spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'salmon' => [
		'layouts' => ['one','lig'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'detailing2' => [
		'name' => 'Detailing 2',
		'categories' => ['car'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['detailing2.zip','detailing2-content.zip',
		],
	],
	'drawing' => [
		'layouts' => ['por'],
		'categories' => ['art','des'],
		'plugins' => ['cf7','rev',
		],
	],
	'mockup' => [
		'layouts' => ['por','dar'],
		'categories' => ['des'],
		'plugins' => ['cf7','rev',
		],
	],
	'denim' => [
		'layouts' => ['sho'],
		'categories' => ['fas'],
		'plugins' => ['cf7','rev','woo',
		],
	],
	'manicure' => [
		'layouts' => ['sho','lig'],
		'categories' => ['fas','hea'],
		'plugins' => ['cf7','rev','woo'],
		'pages' => [
			'woocommerce_shop_page_id' => 'Manicure store',
		],
	],
  'meeting' => [
		'layouts' => ['blo'],
		'categories' => ['occ'],
		'plugins' => ['cf7','rev'],
    'pages' => [
      'page_for_posts' => 'Events',
    ],
	],
	'vegetables' => [
		'categories' => ['foo','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'meat' => [
		'layouts' => ['blo'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'cafe2' => [
		'name' => 'Cafe 2',
		'layouts' => ['lig'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'tiles2' => [
		'name' => 'Tiles 2',
		'layouts' => ['por'],
		'categories' => ['pro'],
		'plugins' => ['rev'],
		'revslider' => ['tiles2.zip','tiles2-content.zip',
		],
	],
	'hiphop' => [
		'name' => 'Hip Hop',
		'layouts' => ['blo','dar'],
		'categories' => ['art','ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'game' => [
		'layouts' => ['one'],
		'categories' => ['tec','ent'],
		'plugins' => ['rev',
		],
	],
	'marina' => [
		'layouts' => ['blo'],
		'categories' => ['spo'],
		'plugins' => ['cf7',
		],
	],
	'clinic2' => [
		'name' => 'Clinic 2',
		'categories' => ['hea'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['clinic2.zip','clinic2-content.zip',
		],
	],
	'assistance' => [
		'layouts' => ['one'],
		'categories' => ['car','peo'],
		'plugins' => ['rev',
		],
	],
	'sushi2' => [
		'name' => 'Sushi 2',
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'repair' => [
		'layouts' => ['dar'],
		'categories' => ['hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'3d' => [
		'layouts' => ['por','dar'],
		'categories' => ['des','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'code' => [
		'layouts' => ['blo'],
		'categories' => ['des','tec'],
		'plugins' => ['cf7',
		],
	],
	'spa2' => [
		'name' => 'Spa 2',
		'categories' => ['hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'it' => [
		'name' => 'IT',
		'layouts' => ['lig'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'upholsterer' => [
		'layouts' => ['one','dar'],
		'categories' => ['fas','peo'],
		'plugins' => ['cf7',
		],
	],
	'fareast' => [
		'name' => 'Far East',
		'layouts' => ['blo','dar'],
		'categories' => ['art','mag'],
		'plugins' => ['cf7',
		],
	],
	'loans2' => [
		'name' => 'Loans 2',
		'layouts' => ['one'],
		'categories' => ['fin'],
		'plugins' => ['cf7','rev',
		],
	],
	'philharmonic' => [
		'layouts' => ['blo'],
		'categories' => ['art','ent'],
		'plugins' => ['cf7',
		],
	],
	'garden2' => [
		'name' => 'Garden 2',
		'layouts' => ['por'],
		'categories' => ['hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'weddingvideos' => [
		'name' => 'Wedding Videos',
		'layouts' => ['por','dar'],
		'categories' => ['des','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'animalshelter' => [
		'name' => 'Animal Shelter',
		'layouts' => ['por'],
		'categories' => ['ani'],
		'plugins' => ['cf7','rev',
		],
	],
	'craftbeer' => [
		'name' => 'Craft Beer',
		'layouts' => ['dar'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'elearning' => [
		'name' => 'eLearning',
		'layouts' => ['blo'],
		'categories' => ['edu'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['elearning.zip','elearning-content.zip',
		],
	],
	'artist' => [
		'layouts' => ['por','dar'],
		'categories' => ['art','des'],
		'plugins' => ['cf7','rev',
		],
	],
	'oculist' => [
		'layouts' => ['box','lig'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'sportsclub' => [
		'name' => 'Sports Club',
		'categories' => ['spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'productions' => [
		'layouts' => ['dar'],
		'categories' => ['art','des'],
		'plugins' => ['cf7','rev',
		],
	],
	'diet' => [
		'layouts' => ['blo'],
		'categories' => ['foo','mag'],
		'plugins' => ['cf7',
		],
	],
	'boutique' => [
		'layouts' => ['blo'],
		'categories' => ['fas'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['boutique.zip','boutique-content.zip',
		],
	],
	'stone' => [
		'categories' => ['cor','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'guesthouse' => [
		'name' => 'Guest House',
		'categories' => ['hou'],
		'plugins' => ['cf7',
		],
	],
	'wildlife' => [
		'layouts' => ['blo','box'],
		'categories' => ['ani','mag'],
		'plugins' => ['cf7','rev',
		],
	],
	'restaurant2' => [
		'name' => 'Restaurant 2',
		'layouts' => ['blo','lig'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['restaurant2.zip','restaurant2-content.zip',
		],
	],
	'dentist2' => [
		'name' => 'Dentist 2',
		'layouts' => ['box','lig'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'furniture2' => [
		'name' => 'Furniture 2',
		'layouts' => ['por'],
		'categories' => ['peo','hou','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'creative2' => [
		'name' => 'Creative 2',
		'layouts' => ['por'],
		'categories' => ['des','cor'],
		'plugins' => ['cf7','rev',
		],
	],
	'wine2' => [
		'name' => 'Wine 2',
		'layouts' => ['por'],
		'categories' => ['foo'],
		'plugins' => ['cf7',
		],
	],
	'detailing' => [
		'layouts' => ['dar'],
		'categories' => ['car'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['detailing.zip','detailing-content.zip',
		],
	],
	'home' => [
		'layouts' => ['por','lig'],
		'categories' => ['hou'],
		'plugins' => ['cf7',
		],
	],
	'active' => [
		'layouts' => ['one','lig'],
		'categories' => ['hea','spo'],
		'plugins' => ['rev',
		],
	],
	'shoes' => [
		'layouts' => ['sho','lig'],
		'categories' => ['fas'],
		'plugins' => ['cf7','rev','woo',
		],
	],
	'corporation' => [
		'layouts' => ['lig'],
		'categories' => ['cor'],
		'plugins' => ['cf7','rev',
		],
	],
	'musician' => [
		'layouts' => ['blo','por'],
		'categories' => ['art','ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'developer2' => [
		'name' => 'Developer 2',
		'layouts' => ['blo','por','lig'],
		'categories' => ['hou','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'xmas2' => [
		'name' => 'Xmas 2',
		'layouts' => ['one','dar'],
		'categories' => ['occ'],
		'plugins' => ['cf7',
		],
	],
	'fireplace' => [
		'layouts' => ['sho','box','dar'],
		'categories' => ['hou'],
		'plugins' => ['cf7','rev','woo',
		],
	],
	'training' => [
		'layouts' => ['blo'],
		'categories' => ['edu','peo','mag'],
		'plugins' => ['cf7'],
    'pages' => [
			'page_for_posts' => 'Events calendar',
		],
	],
	'couturier' => [
		'categories' => ['fas'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['couturier-box1.zip','couturier-box2.zip',
		],
	],
	'surveyor' => [
		'layouts' => ['box','lig'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
  'wallet' => [
		'layouts' => ['blo'],
		'categories' => ['tec','fin'],
		'plugins' => ['cf7','rev'],
    'pages' => [
      'page_for_posts' => 'Articles',
    ],
	],
	'herbal' => [
		'layouts' => ['sho'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev','woo',
		],
	],
  'snapshot' => [
		'layouts' => ['blo','por'],
		'categories' => ['ani','des','spo'],
		'plugins' => ['cf7'],
    'pages' => [
			'page_for_posts' => 'Read my stories',
		],
	],
	'biolab' => [
		'categories' => ['edu'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['biolab-content.zip','biolab-content2.zip',
		],
	],
	'moto' => [
		'layouts' => ['blo'],
		'categories' => ['car'],
		'plugins' => ['cf7','rev',
		],
	],
	'logistics' => [
		'layouts' => ['lig'],
		'categories' => ['cor','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'pizza2' => [
		'name' => 'Pizza 2',
		'categories' => ['foo'],
		'plugins' => ['cf7',
		],
	],
	'hifi' => [
		'name' => 'HiFi',
		'layouts' => ['sho'],
		'categories' => ['tec','pro'],
		'plugins' => ['cf7','woo',
		],
	],
	'ebook' => [
		'name' => 'eBook',
		'layouts' => ['one'],
		'categories' => ['mag'],
		'plugins' => ['cf7',
		],
	],
	'lawyer2' => [
		'name' => 'Lawyer 2',
		'categories' => ['fin','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'watch' => [
		'layouts' => ['lig'],
		'categories' => ['tec','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'tailor' => [
		'layouts' => ['box'],
		'categories' => ['fas','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'biker' => [
		'layouts' => ['sho'],
		'categories' => ['car'],
		'plugins' => ['cf7','rev','woo'],
		'pages' => [
			'woocommerce_shop_page_id' => 'SHOP',
		],
	],
	'writer' => [
		'layouts' => ['blo'],
		'categories' => ['mag'],
		'plugins' => ['cf7','rev',
		],
	],
	'mechanic2' => [
		'name' => 'Mechanic 2',
		'categories' => ['car','peo','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'barber2' => [
		'name' => 'Barber 2',
		'categories' => ['fas','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'goodfood' => [
		'layouts' => ['blo'],
		'categories' => ['foo','hea','mag'],
		'plugins' => ['cf7'],
    'pages' => [
      'page_for_posts' => 'Food blog',
    ],
	],
	'agency2' => [
		'name' => 'Agency 2',
		'layouts' => ['one','lig'],
		'categories' => ['cor'],
		'plugins' => ['cf7','rev',
		],
	],
	'minimal' => [
		'layouts' => ['por'],
		'categories' => ['des'],
		'plugins' => ['cf7','rev',
		],
	],
	'medic2' => [
		'name' => 'Medic 2',
		'layouts' => ['box'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'underwater' => [
		'categories' => ['ani','edu','ent','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'seo2' => [
		'name' => 'SEO 2',
		'categories' => ['tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'smarthome' => [
		'categories' => ['hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'car' => [
		'categories' => ['car'],
		'plugins' => ['cf7','rev',
		],
	],
	'makeup' => [
		'layouts' => ['one','lig'],
		'categories' => ['fas','hea','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'architect2' => [
		'name' => 'Architect 2',
		'layouts' => ['por','lig'],
		'categories' => ['des','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'wedding2' => [
		'name' => 'Wedding 2',
		'layouts' => ['lig'],
		'categories' => ['peo'],
		'plugins' => ['rev',
		],
	],
	'technics' => [
		'categories' => ['cor','edu','tec','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'aquapark' => [
		'layouts' => ['lig'],
		'categories' => ['ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'print' => [
		'categories' => ['des','tec','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'perfume' => [
		'layouts' => ['one','lig'],
		'categories' => ['hea'],
		'plugins' => ['rev',
		],
	],
	'movie' => [
		'categories' => ['art','ent'],
		'plugins' => ['rev',
		],
	],
	'eco' => [
		'layouts' => ['blo'],
		'categories' => ['ani','edu'],
		'plugins' => ['cf7','rev',
		],
	],
	'bistro' => [
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
  'ngo' => [
		'layouts' => ['lig'],
		'categories' => ['cor'],
		'plugins' => ['cf7','rev'],
    'pages' => [
			'page_for_posts' => 'News and events',
		],
	],
	'casino' => [
		'layouts' => ['one'],
		'categories' => ['ent'],
		'plugins' => ['rev',
		],
	],
	'pharmacy' => [
		'layouts' => ['sho','box','lig'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev','woo'],
		'pages' => [
			'page_for_posts' => 'Articles',
		],
	],
	'hr' => [
		'categories' => ['cor'],
		'plugins' => ['cf7','rev',
		],
	],
	'music' => [
		'categories' => ['art','ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'vpn' => [
		'categories' => ['tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'pets' => [
		'layouts' => ['blo'],
		'categories' => ['ani','mag'],
		'plugins' => ['cf7',
		],
	],
	'tiles' => [
		'layouts' => ['por'],
		'categories' => ['pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'freelancer' => [
		'layouts' => ['por','dar'],
		'categories' => ['des','tec','peo'],
		'plugins' => ['cf7',
		],
	],
	'lifestyle' => [
		'layouts' => ['blo'],
		'categories' => ['mag'],
		'plugins' => ['cf7',
		],
	],
	'app2' => [
		'name' => 'App 2',
		'layouts' => ['one'],
		'categories' => ['tec'],
		'plugins' => ['rev',
		],
	],
	'kebab' => [
		'categories' => ['foo'],
		'plugins' => ['cf7',
		],
	],
	'holding' => [
		'categories' => ['cor'],
		'plugins' => ['cf7','rev',
		],
	],
	'tea' => [
		'categories' => ['foo','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'toy' => [
		'categories' => ['ent','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'charity2' => [
		'name' => 'Charity 2',
		'layouts' => ['dar'],
		'categories' => ['cor','occ','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'carpenter' => [
		'layouts' => ['box'],
		'categories' => ['des','peo','hou','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'mining' => [
		'categories' => ['pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'retouch' => [
		'layouts' => ['box'],
		'categories' => ['des'],
		'plugins' => ['cf7','rev',
		],
	],
	'accountant' => [
		'layouts' => ['box','lig'],
		'categories' => ['fin','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'sushi' => [
		'categories' => ['foo'],
		'plugins' => ['rev',
		],
	],
	'beauty2' => [
		'name' => 'Beauty 2',
		'layouts' => ['lig'],
		'categories' => ['hea'],
		'plugins' => ['cf7',
		],
	],
	'fitness' => [
		'layouts' => ['box'],
		'categories' => ['hea','spo'],
		'plugins' => ['rev'],
		'revslider' => ['fitness.zip','fitness-content.zip',
		],
	],
	'design2' => [
		'name' => 'Design 2',
		'categories' => ['des','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'painter' => [
		'layouts' => ['por','lig'],
		'categories' => ['art','des'],
		'plugins' => ['cf7',
		],
	],
	'kindergarten' => [
		'layouts' => ['lig'],
		'categories' => ['edu'],
		'plugins' => ['rev','cf7',
		],
	],
	'ski' => [
		'layouts' => ['one'],
		'categories' => ['spo'],
		'plugins' => ['rev',
		],
	],
	'blogger2' => [
		'name' => 'Blogger 2',
		'layouts' => ['blo','lig','ele','mfn'],
		'categories' => ['mag'],
		'plugins' => ['ele'],
		'wrapper' => '1260',
	],
	'service' => [
		'layouts' => ['one','lig'],
		'categories' => ['peo','hou',
		],
	],
	'firm' => [
		'categories' => ['cor'],
		'plugins' => ['cf7',
		],
	],
	'interior2' => [
		'name' => 'Interior 2',
		'layouts' => ['por','lig'],
		'categories' => ['des','hou'],
		'plugins' => ['rev',
		],
	],
	'industry' => [
		'categories' => ['pro'],
		'plugins' => ['cf7',
		],
	],
	'journey' => [
		'layouts' => ['blo'],
		'categories' => ['spo'],
		'plugins' => ['cf7'],
    'pages' => [
			'page_for_posts' => 'ARTICLES AND STORIES',
		],
	],
	'science' => [
		'layouts' => ['blo'],
		'categories' => ['edu'],
		'plugins' => ['cf7','rev',
		],
	],
	'carver' => [
		'layouts' => ['por','lig'],
		'categories' => ['art','des','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'hotel2' => [
		'name' => 'Hotel 2',
		'layouts' => ['lig'],
		'categories' => ['foo','hou','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'moving2' => [
		'name' => 'Moving 2',
		'layouts' => ['box'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'billiard' => [
		'categories' => ['ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'business2' => [
		'name' => 'Business 2',
		'categories' => ['cor'],
		'plugins' => ['cf7','rev',
		],
	],
	'renovate2' => [
		'name' => 'Renovate 2',
		'layouts' => ['lig'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'xmas' => [
		'layouts' => ['one'],
		'categories' => ['occ'],
		'plugins' => ['rev','mch',
		],
	],
	'exposure' => [
		'layouts' => ['por'],
		'categories' => ['des'],
		'plugins' => ['cf7',
		],
	],
	'burger' => [
		'categories' => ['foo'],
		'plugins' => ['rev',
		],
	],
	'profile' => [
		'layouts' => ['por','one'],
		'categories' => ['peo','oth'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['profile.zip','profile-portfolio.zip',
		],
	],
	'farmer' => [
		'layouts' => ['lig'],
		'categories' => ['pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'copywriter' => [
		'layouts' => ['blo','lig'],
		'categories' => ['peo','mag'],
		'plugins' => ['cf7','rev',
		],
	],
	'horse' => [
		'name' => 'Horse Riding',
		'categories' => ['ani','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'notebook' => [
		'layouts' => ['one'],
		'categories' => ['tec',
		],
	],
	'dietitian' => [
		'layouts' => ['lig'],
		'categories' => ['foo','hea','peo'],
		'plugins' => ['cf7',
		],
	],
	'investment' => [
		'categories' => ['cor','fin'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['investment.zip','investment-content.zip',
		],
	],
	'handmade' => [
		'layouts' => ['box','lig'],
		'categories' => ['des','fas'],
		'plugins' => ['cf7','rev',
		],
	],
  'space' => [
    'layouts' => ['blo'],
    'categories' => ['cor','edu','pro'],
    'plugins' => ['rev'],
    'pages' => [
      'page_for_posts' => 'Articles',
    ],
  ],
  'club' => [
		'layouts' => ['blo'],
		'categories' => ['ent'],
		'plugins' => ['cf7','rev'],
    'pages' => [
			'page_for_posts' => 'UPCOMING EVENTS',
		],
	],
	'buddy' => [
		'layouts' => ['lig'],
		'categories' => ['mag'],
		'plugins' => ['bud','rev',
		],
	],
	'lab' => [
		'categories' => ['edu','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'zoo' => [
		'categories' => ['ani','ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'asg' => [
		'name' => 'ASG',
		'layouts' => ['box'],
		'categories' => ['ent','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'journalist' => [
		'layouts' => ['blo'],
		'categories' => ['peo','mag'],
		'plugins' => ['cf7','rev',
		],
	],
	'simple' => [
		'layouts' => ['box','lig'],
		'categories' => ['ani','oth'],
		'plugins' => ['cf7',
		],
	],
	'extreme' => [
		'categories' => ['ent','peo','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'voyager' => [
		'layouts' => ['blo'],
		'categories' => ['spo','mag'],
		'plugins' => ['cf7',
		],
	],
	'typo' => [
		'layouts' => ['por'],
		'categories' => ['des','mag'],
		'plugins' => ['cf7',
		],
	],
	'tuning' => [
		'layouts' => ['por','lig'],
		'categories' => ['car','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'smart' => [
		'layouts' => ['one'],
		'categories' => ['tec'],
		'plugins' => ['rev',
		],
	],
	'glasses' => [
		'categories' => ['fas'],
		'plugins' => ['cf7','rev',
		],
	],
	'taxi' => [
		'layouts' => ['one','dar'],
		'categories' => ['car','peo'],
		'plugins' => ['cf7',
		],
	],
	'decor' => [
		'categories' => ['des','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'builder' => [
		'layouts' => ['box'],
		'categories' => ['hou','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'karting' => [
		'layouts' => ['blo'],
		'categories' => ['spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'coaching' => [
		'layouts' => ['box','lig'],
		'categories' => ['edu','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'wine' => [
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'surfing' => [
		'layouts' => ['lig'],
		'categories' => ['spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'garden' => [
		'layouts' => ['por','lig'],
		'categories' => ['hou'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['garden-content.zip','garden-content2.zip',
		],
	],
	'software' => [
		'categories' => ['tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'library' => [
		'layouts' => ['blo'],
		'categories' => ['edu','mag'],
		'plugins' => ['cf7','rev',
		],
	],
	'digital' => [
		'layouts' => ['por'],
		'categories' => ['des','tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'icecream' => [
		'name' => 'Ice Cream',
		'layouts' => ['lig'],
		'categories' => ['foo'],
		'plugins' => ['rev',
		],
	],
	'constructor' => [
		'layouts' => ['por'],
		'categories' => ['des','hou','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'interactive' => [
		'layouts' => ['por','lig'],
		'categories' => ['des','cor','tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'agro' => [
		'categories' => ['pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'media' => [
		'layouts' => ['por','one'],
		'categories' => ['cor','tec','fin'],
		'plugins' => ['cf7','rev',
		],
	],
	'cosmetics' => [
		'layouts' => ['sho','lig'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev','woo'],
		'revslider' => ['cosmetics1.zip','cosmetics2.zip','cosmetics3.zip',
		],
	],
	'jet' => [
		'layouts' => ['dar'],
		'categories' => ['spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'dentist' => [
		'layouts' => ['lig'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'kravmaga' => [
		'name' => 'Krav Maga',
		'layouts' => ['por','one','box','dar'],
		'categories' => ['spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'transfer' => [
		'categories' => ['cor','fin'],
		'plugins' => ['cf7','rev',
		],
	],
	'showcase' => [
		'layouts' => ['por'],
		'categories' => ['des'],
		'plugins' => ['cf7',
		],
	],
	'cafe' => [
		'layouts' => ['box','lig'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'bikerental' => [
		'name' => 'Bike Rental',
		'layouts' => ['lig'],
		'categories' => ['car','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'massage' => [
		'categories' => ['hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'callcenter' => [
		'name' => 'Call Center',
		'layouts' => ['blo','lig'],
		'categories' => ['cor'],
		'plugins' => ['cf7','rev',
		],
	],
	'golf' => [
		'layouts' => ['blo','lig'],
		'categories' => ['ent','spo'],
		'plugins' => ['cf7',
		],
	],
	'theater' => [
		'layouts' => ['blo'],
		'categories' => ['art','ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'flower' => [
		'categories' => ['occ'],
		'plugins' => ['cf7','rev',
		],
	],
	'handyman' => [
		'layouts' => ['por'],
		'categories' => ['hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'translator' => [
		'categories' => ['mag'],
		'plugins' => ['cf7','rev',
		],
	],
	'story' => [
		'layouts' => ['lig'],
		'categories' => ['ani','mag'],
		'plugins' => ['cf7','rev',
		],
	],
	'factory' => [
		'categories' => ['car','cor','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'recipes' => [
		'layouts' => ['blo','box'],
		'categories' => ['foo','mag'],
		'plugins' => ['cf7','rev',
		],
	],
	'sport' => [
		'layouts' => ['por'],
		'categories' => ['spo'],
		'plugins' => ['cf7','rev','mch',
		],
	],
	'store' => [
		'layouts' => ['blo','sho'],
		'categories' => ['fas'],
		'plugins' => ['cf7','rev','mch','woo',
		],
	],
	'animals' => [
		'layouts' => ['blo'],
		'categories' => ['ani'],
		'plugins' => ['cf7','rev',
		],
	],
	'webdesign' => [
		'name' => 'WebDesign',
		'layouts' => ['por'],
		'categories' => ['des','tec'],
		'plugins' => ['cf7','rev','mch',
		],
	],
	'safari' => [
		'layouts' => ['one','dar'],
		'categories' => ['spo',
		],
	],
	'adagency' => [
		'name' => 'AdAgency',
		'layouts' => ['por','box'],
		'categories' => ['des'],
		'plugins' => ['cf7','rev','mch'],
		'revslider' => ['adagency.zip','adagency-content.zip',
		],
	],
	'congress' => [
		'layouts' => ['blo','lig'],
		'categories' => ['cor','mag'],
		'plugins' => ['cf7','rev',
		],
	],
	'video' => [
		'layouts' => ['por'],
		'categories' => ['des'],
		'plugins' => ['cf7','rev',
		],
	],
	'steak' => [
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'clinic' => [
		'categories' => ['hea'],
		'plugins' => ['cf7',
		],
	],
	'play' => [
		'layouts' => ['one','lig'],
		'categories' => ['tec','ent'],
		'plugins' => ['cf7',
		],
	],
	'fashion' => [
		'layouts' => ['blo'],
		'categories' => ['fas'],
		'plugins' => ['cf7',
		],
	],
	'disco' => [
		'layouts' => ['one','lig'],
		'categories' => ['ent','foo','peo',
		],
	],
	'fix' => [
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'bar' => [
		'layouts' => ['box'],
		'categories' => ['ent','foo'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['bar.zip','bar-content.zip',
		],
	],
	'coffee' => [
		'layouts' => ['lig'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'finance' => [
		'layouts' => ['box','lig'],
		'categories' => ['cor','fin'],
		'plugins' => ['cf7',
		],
	],
	'cleaner' => [
		'layouts' => ['blo','lig'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'itservice' => [
		'name' => 'IT Service',
		'layouts' => ['one','lig'],
		'categories' => ['tec'],
		'plugins' => ['rev',
		],
	],
	'jeweler' => [
		'layouts' => ['por','dar'],
		'categories' => ['fas','occ'],
		'plugins' => ['cf7','rev',
		],
	],
	'records' => [
		'categories' => ['pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'politics' => [
		'layouts' => ['blo'],
		'categories' => ['cor','mag'],
		'plugins' => ['rev',
		],
	],
	'pole' => [
		'layouts' => ['one','dar'],
		'categories' => ['art','ent','peo','spo'],
		'plugins' => ['rev',
		],
	],
	'energy' => [
		'categories' => ['edu','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'launch' => [
		'layouts' => ['one'],
		'categories' => ['oth'],
		'plugins' => ['mch',
		],
	],
	'tattoo' => [
		'layouts' => ['por','dar'],
		'categories' => ['des','hea','peo'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['tattoo.zip','tattoo-content.zip',
		],
	],
	'yoga' => [
		'layouts' => ['one'],
		'categories' => ['hea','spo'],
		'plugins' => ['mch','rev',
		],
	],
	'insurance' => [
		'layouts' => ['lig'],
		'categories' => ['cor','fin','hea'],
		'plugins' => ['cf7',
		],
	],
	'driving' => [
		'categories' => ['car','edu'],
		'plugins' => ['cf7','rev',
		],
	],
	'party' => [
		'layouts' => ['one','dar'],
		'categories' => ['ent','occ'],
		'plugins' => ['mch','rev',
		],
	],
	'vision' => [
		'categories' => ['hea'],
		'plugins' => ['cf7',
		],
	],
	'model' => [
		'layouts' => ['por'],
		'categories' => ['fas'],
		'plugins' => ['cf7','rev',
		],
	],
	'pr' => [
		'name' => 'PR',
		'categories' => ['cor'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['pr.zip','pr-content.zip',
		],
	],
	'baker' => [
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'language' => [
		'layouts' => ['blo'],
		'categories' => ['edu'],
		'plugins' => ['cf7','rev',
		],
	],
	'security' => [
		'categories' => ['cor','peo','oth'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['security.zip','security-content.zip',
		],
	],
	'furniture' => [
		'layouts' => ['por','lig'],
		'categories' => ['peo','hou','pro'],
		'plugins' => ['cf7',
		],
	],
	'museum' => [
		'layouts' => ['blo'],
		'categories' => ['art'],
		'plugins' => ['cf7','rev',
		],
	],
	'architect' => [
		'layouts' => ['por'],
		'categories' => ['des','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'electric' => [
		'categories' => ['tec','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'vet' => [
		'layouts' => ['box'],
		'categories' => ['ani','hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'loans' => [
		'layouts' => ['one'],
		'categories' => ['fin'],
		'plugins' => ['cf7',
		],
	],
	'charity' => [
		'categories' => ['cor','occ','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'sitter' => [
		'layouts' => ['lig'],
		'categories' => ['peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'moving' => [
		'layouts' => ['box'],
		'categories' => ['hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'fit' => [
		'layouts' => ['one','lig'],
		'categories' => ['foo','hea','spo'],
		'plugins' => ['rev',
		],
	],
	'barber' => [
		'layouts' => ['box','dar'],
		'categories' => ['fas','peo'],
		'plugins' => ['rev',
		],
	],
	'book' => [
		'categories' => ['art','mag'],
		'plugins' => ['cf7',
		],
	],
	'plumber' => [
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'dj' => [
		'name' => 'DJ',
		'layouts' => ['one'],
		'categories' => ['ent','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'sketch' => [
		'layouts' => ['one','lig'],
		'categories' => ['des',
		],
	],
	'bw' => [
		'name' => 'B&W',
		'layouts' => ['por','lig'],
		'categories' => ['des'],
		'plugins' => ['cf7',
		],
	],
	'tourist' => [
		'layouts' => ['blo','box'],
		'categories' => ['spo','mag'],
		'plugins' => ['cf7','rev',
		],
	],
	'art' => [
		'layouts' => ['one'],
		'categories' => ['art','des',
		],
	],
	'interior' => [
		'layouts' => ['por','dar'],
		'categories' => ['des','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'webmaster' => [
		'layouts' => ['por'],
		'categories' => ['tec','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'app' => [
		'layouts' => ['lig'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'seo' => [
		'layouts' => ['lig'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'pizza' => [
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'event' => [
		'layouts' => ['blo'],
		'categories' => ['ent'],
		'plugins' => ['cf7','rev',
		],
	],
	'developer' => [
		'categories' => ['hou','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'carrental' => [
		'name' => 'Car Rental',
		'layouts' => ['lig'],
		'categories' => ['car'],
		'plugins' => ['cf7','rev',
		],
	],
	'band' => [
		'layouts' => ['one','dar'],
		'categories' => ['ent',
		],
	],
	'university' => [
		'layouts' => ['blo','box'],
		'categories' => ['cor','edu'],
		'plugins' => ['cf7','rev',
		],
	],
	'spa' => [
		'layouts' => ['lig'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev'],
		'revslider' => ['spa.zip','spa-content.zip',
		],
	],
	'press' => [
		'layouts' => ['blo','lig'],
		'categories' => ['mag'],
		'plugins' => ['rev',
		],
	],
	'gym' => [
		'categories' => ['spo'],
		'plugins' => ['cf7',
		],
	],
	'design' => [
		'layouts' => ['por'],
		'categories' => ['des'],
		'plugins' => ['cf7',
		],
	],
	'marketing' => [
		'layouts' => ['one'],
		'categories' => ['des','fas',
		],
	],
	'hosting' => [
		'layouts' => ['lig'],
		'categories' => ['tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'travel' => [
		'layouts' => ['box'],
		'categories' => ['spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'agency' => [
		'categories' => ['des'],
		'plugins' => ['cf7','rev',
		],
	],
	'estate' => [
		'categories' => ['hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'beauty' => [
		'layouts' => ['lig'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'blogger' => [
		'layouts' => ['blo','box','lig'],
		'categories' => ['mag'],
		'plugins' => ['rev',
		],
	],
	'business' => [
		'layouts' => ['box'],
		'categories' => ['cor'],
		'plugins' => ['cf7','rev',
		],
	],
	'church' => [
		'layouts' => ['blo'],
		'categories' => ['art'],
		'plugins' => ['cf7','rev',
		],
	],
	'creative' => [
		'layouts' => ['por'],
		'categories' => ['des'],
		'plugins' => ['cf7',
		],
	],
	'hotel' => [
		'categories' => ['foo','hou','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'landing' => [
		'name' => 'Landing Page',
		'layouts' => ['one'],
		'categories' => ['des','tec'],
		'plugins' => ['cf7','rev',
		],
	],
	'lawyer' => [
		'categories' => ['fin','peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'mechanic' => [
		'categories' => ['car','peo','pro'],
		'plugins' => ['cf7','rev',
		],
	],
	'medic' => [
		'layouts' => ['lig'],
		'categories' => ['hea'],
		'plugins' => ['cf7','rev',
		],
	],
	'onepage' => [
		'name' => 'One Page',
		'layouts' => ['blo','por','sho','one'],
		'categories' => ['oth'],
		'plugins' => ['rev'],
		'revslider' => ['onepage.zip','onepage-content.zip',
		],
	],
	'parallax' => [
		'layouts' => ['por','one'],
		'categories' => ['des','oth',
		],
	],
	'photo' => [
		'layouts' => ['por'],
		'categories' => ['des'],
		'plugins' => ['cf7','rev',
		],
	],
	'portfolio' => [
		'layouts' => ['por'],
		'categories' => ['des'],
		'plugins' => ['cf7','rev',
		],
	],
	'renovate' => [
		'layouts' => ['box','lig'],
		'categories' => ['peo','hou'],
		'plugins' => ['cf7','rev',
		],
	],
	'restaurant' => [
		'layouts' => ['lig'],
		'categories' => ['foo'],
		'plugins' => ['cf7','rev',
		],
	],
	'resume' => [
		'layouts' => ['por','one','box'],
		'categories' => ['peo','oth'],
		'plugins' => ['cf7',
		],
	],
	'school' => [
		'layouts' => ['blo'],
		'categories' => ['edu'],
		'plugins' => ['cf7','rev',
		],
	],
	'shop' => [
		'layouts' => ['sho'],
		'categories' => ['fas'],
		'plugins' => ['cf7','rev','woo',
		],
	],
	'transport' => [
		'categories' => ['car','cor','spo'],
		'plugins' => ['cf7','rev',
		],
	],
	'wedding' => [
		'layouts' => ['lig'],
		'categories' => ['peo'],
		'plugins' => ['cf7','rev',
		],
	],
	'placeholder' => [
	],
];
